/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.FilePathValidator;
import com.sap.core.utils.destinations.validation.validators.http.KeyStoreUtil;
import com.sap.core.utils.destinations.validation.validators.http.consts.HttpConstants;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class KeyStoreLocationValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet set;
        boolean keyStoreLocationExists = properties.containsKey("KeyStoreLocation");
        KeyStoreUtil util = new KeyStoreUtil(properties, "KeyStoreLocation", ViolationType.KEY_STORE_LOCATION_REDUNDANT);
        boolean isKeyStoreLocationNeeded = util.isPropertyNeeded();
        ViolationSet violations = util.getViolationsOccurred();
        if (isKeyStoreLocationNeeded && !keyStoreLocationExists) {
            violations.add(new Violation(ViolationType.KEY_STORE_LOCATION_MISSING, Messages.getMessage("PropertyMissing", "KeyStoreLocation"), Severity.ERROR));
            return violations;
        }
        if (isKeyStoreLocationNeeded && keyStoreLocationExists && ((set = this.proceedFilePathValidation(properties)).hasErrors() || set.hasWarnings())) {
            violations.addSet(set);
            return violations;
        }
        return violations;
    }

    public ViolationSet proceedFilePathValidation(Properties properties) {
        FilePathValidator pathValidator = new FilePathValidator("KeyStoreLocation", HttpConstants.allowedKeyStoreExtensions);
        return pathValidator.validate(properties);
    }
}

