/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.http.KeyStoreUtil;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class KeyStorePasswordValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        boolean keyStorePasswordExists = properties.containsKey("KeyStorePassword");
        KeyStoreUtil util = new KeyStoreUtil(properties, "KeyStorePassword", ViolationType.KEY_STORE_PASSWORD_REDUNDANT);
        boolean isKeyStorePasswordNeeded = util.isPropertyNeeded();
        ViolationSet violations = util.getViolationsOccurred();
        if (isKeyStorePasswordNeeded && !keyStorePasswordExists) {
            violations.add(new Violation(ViolationType.KEY_STORE_PASSWORD_MISSING, Messages.getMessage("PropertyMissing", "KeyStorePassword"), Severity.ERROR));
            return violations;
        }
        if (isKeyStorePasswordNeeded && keyStorePasswordExists) {
            return violations;
        }
        return violations;
    }
}

