/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

class KeyStoreUtil {
    private boolean isPropertyNeeded = false;
    private ViolationSet violationSet = new ViolationSet();

    boolean isPropertyNeeded() {
        return this.isPropertyNeeded;
    }

    ViolationSet getViolationsOccurred() {
        return this.violationSet;
    }

    KeyStoreUtil(Properties properties, String keyStoreProperty, ViolationType keyStorePropertyRedundant) {
        this.violationSet.addSet(this.preparatoryChecks(properties, keyStoreProperty, keyStorePropertyRedundant));
    }

    private ViolationSet preparatoryChecks(Properties properties, String keyStoreProperty, ViolationType keyStorePropertyRedundant) {
        String proxyType;
        ViolationSet violations = new ViolationSet();
        boolean keyStorePropertyExists = properties.containsKey(keyStoreProperty);
        boolean isHttpsUsed = false;
        boolean isProxyTypeInternet = true;
        boolean isAuthenticationClientCertificate = false;
        if (!properties.containsKey("URL")) {
            violations.add(new Violation(ViolationType.URL_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "URL", keyStoreProperty), Severity.WARNING));
            return violations;
        }
        if (properties.containsKey("URL")) {
            String url = properties.getProperty("URL").trim();
            if (url.startsWith("https")) {
                isHttpsUsed = true;
            }
            if (!url.startsWith("https") && keyStorePropertyExists) {
                violations.add(new Violation(keyStorePropertyRedundant, Messages.getMessage("PropertyRedundantDueToUrl", keyStoreProperty), Severity.WARNING));
                return violations;
            }
        }
        if ((proxyType = properties.getProperty("ProxyType")) != null && !proxyType.trim().equals("Internet")) {
            isProxyTypeInternet = false;
        }
        if (!isProxyTypeInternet && keyStorePropertyExists) {
            violations.add(new Violation(keyStorePropertyRedundant, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", keyStoreProperty, "ProxyType", "Internet"), Severity.WARNING));
            return violations;
        }
        if (!properties.containsKey("Authentication")) {
            violations.add(new Violation(ViolationType.AUTHENTICATION_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "Authentication", keyStoreProperty), Severity.WARNING));
            return violations;
        }
        if (properties.containsKey("Authentication")) {
            String authentication = properties.getProperty("Authentication").trim();
            if (authentication.equals("ClientCertificateAuthentication")) {
                isAuthenticationClientCertificate = true;
            }
            if (!authentication.equals("ClientCertificateAuthentication") && keyStorePropertyExists) {
                violations.add(new Violation(keyStorePropertyRedundant, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", keyStoreProperty, "Authentication", "ClientCertificateAuthentication"), Severity.WARNING));
                return violations;
            }
        }
        if (isHttpsUsed && isProxyTypeInternet && isAuthenticationClientCertificate) {
            this.isPropertyNeeded = true;
        }
        return violations;
    }
}

