/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class PreemptiveValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        boolean authenticationExists = properties.containsKey("Authentication");
        if (properties.containsKey("Preemptive")) {
            String value;
            if (!authenticationExists) {
                violations.add(new Violation(ViolationType.AUTHENTICATION_MISSING, Messages.getMessage("AuthenticationMissingCannotStatePreemptiveRedundant", "Preemptive", "Authentication"), Severity.WARNING));
                return violations;
            }
            String authentication = properties.getProperty("Authentication").trim();
            if (authenticationExists && !authentication.equals("BasicAuthentication")) {
                violations.add(new Violation(ViolationType.PREEMPTIVE_REDUNDANT, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", "Preemptive", "Authentication", "BasicAuthentication"), Severity.WARNING));
                return violations;
            }
            if (authenticationExists && authentication.equals("BasicAuthentication") && !(value = properties.getProperty("Preemptive").trim()).toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
                violations.add(new Violation(ViolationType.VALUE_OF_BOOLEAN_PROPERTY_NOT_VALID, Messages.getMessage("BooleanPropertyNotValid", "Preemptive", value), Severity.ERROR));
                return violations;
            }
        }
        return violations;
    }
}

