/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.utils.ValidValuesFormatter;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.http.consts.HttpConstants;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class ProxyTypeValidator
extends Validator {
    private static final String EXCEPTIONAL_CASE = "Internal";

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        if (!properties.containsKey("ProxyType")) {
            return violations;
        }
        String value = properties.getProperty("ProxyType").trim();
        if (!HttpConstants.proxyTypesAllowed.contains(value) && !value.equals(EXCEPTIONAL_CASE)) {
            violations.add(new Violation(ViolationType.PROXY_TYPE_NOT_VALID, Messages.getMessage("ValueIsNotInAllowedRange", value, "ProxyType", ValidValuesFormatter.format(HttpConstants.proxyTypesAllowed)), Severity.ERROR));
            return violations;
        }
        return violations;
    }
}

