/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.utils.CommonUtils;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BooleanValidator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class TrustAllValidator
extends Validator {
    private boolean initialCheck;

    public TrustAllValidator(boolean initialCheck) {
        this.initialCheck = initialCheck;
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        boolean hasSpecifiedURL = CommonUtils.isSetNonEmptyProperty(properties, "URL");
        if (hasSpecifiedURL && properties.getProperty("URL").trim().startsWith("https://")) {
            if (properties.containsKey("TrustAll")) {
                violations.addSet(this.validateTrustAllWithHttpsURL(properties));
            }
        } else if (hasSpecifiedURL && !properties.getProperty("URL").trim().startsWith("https://") && properties.containsKey("TrustAll")) {
            violations.add(new Violation(ViolationType.VALUE_OF_BOOLEAN_PROPERTY_NOT_VALID, Messages.getMessage("IncompatibleTrustAllPropertyWithHttpProtocolErrorMSG", new Object[0]), Severity.ERROR));
        } else if (!hasSpecifiedURL) {
            boolean expression = this.initialCheck && CommonUtils.isSetNonEmptyProperty(properties, "TrustAll");
            violations.add(new Violation(ViolationType.URL_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "URL", "TrustAll = true"), CommonUtils.getSeverityAccordingToClient(expression)));
        }
        return violations;
    }

    private ViolationSet validateTrustAllWithHttpsURL(Properties properties) {
        String value;
        ViolationSet violations = new ViolationSet();
        BooleanValidator boolValidator = new BooleanValidator("TrustAll", false);
        violations.addSet(boolValidator.validate(properties));
        if (!violations.hasErrors() && (value = properties.getProperty("TrustAll").trim()).toLowerCase().equals("true") && properties.containsKey("ProxyType") && properties.getProperty("ProxyType").equals("OnPremise")) {
            violations.add(new Violation(ViolationType.INCOMPATIBLE_PROXY_TYPE_AND_TRUST_ALL, Messages.getMessage("IncompatiblePropertiesErrorMSG", new Object[0]), Severity.ERROR));
        }
        return violations;
    }
}

