/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.utils.CommonUtils;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.FilePathValidator;
import com.sap.core.utils.destinations.validation.validators.http.TrustStoreUtil;
import com.sap.core.utils.destinations.validation.validators.http.consts.HttpConstants;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class TrustStoreLocationValidator
extends Validator {
    private boolean initialCheck;
    private boolean canBeEmpty = true;

    public TrustStoreLocationValidator() {
        this(false);
    }

    public TrustStoreLocationValidator(boolean initialCheck) {
        this.initialCheck = initialCheck;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet set;
        boolean trustStoreLocationExists = properties.containsKey("TrustStoreLocation");
        TrustStoreUtil util = new TrustStoreUtil(properties, "TrustStoreLocation", ViolationType.TRUST_STORE_LOCATION_REDUNDANT);
        boolean isTrustStoreLocationNeeded = util.isPropertyNeeded();
        ViolationSet violations = util.getViolationsOccurred();
        if ((!this.initialCheck && isTrustStoreLocationNeeded || !this.canBeEmpty) && !trustStoreLocationExists) {
            violations.add(new Violation(ViolationType.TRUST_STORE_LOCATION_MISSING, Messages.getMessage("PropertyMissing", "TrustStoreLocation"), CommonUtils.getSeverityAccordingToClient(this.initialCheck)));
            return violations;
        }
        if (isTrustStoreLocationNeeded && trustStoreLocationExists && ((set = this.proceedFilePathValidation(properties)).hasErrors() || set.hasWarnings())) {
            violations.addSet(set);
            return violations;
        }
        return violations;
    }

    public ViolationSet proceedFilePathValidation(Properties properties) {
        FilePathValidator pathValidator = new FilePathValidator("TrustStoreLocation", HttpConstants.allowedTrustStoreExtensions);
        return pathValidator.validate(properties);
    }

    public void setCanBeEmpty(boolean canBeEmpty) {
        this.canBeEmpty = canBeEmpty;
    }
}

