/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.utils.CommonUtils;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.http.TrustStoreUtil;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class TrustStorePasswordValidator
extends Validator {
    private boolean initialCheck;
    private boolean canBeEmpty = true;

    public TrustStorePasswordValidator() {
        this(false);
    }

    public TrustStorePasswordValidator(boolean initialCheck) {
        this.initialCheck = initialCheck;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        boolean trustStorePasswordExists = properties.containsKey("TrustStorePassword");
        TrustStoreUtil util = new TrustStoreUtil(properties, "TrustStorePassword", ViolationType.TRUST_STORE_PASSWORD_REDUNDANT);
        boolean isTrustStorePasswordNeeded = util.isPropertyNeeded();
        ViolationSet violations = util.getViolationsOccurred();
        if ((!this.initialCheck && isTrustStorePasswordNeeded || !this.canBeEmpty) && !trustStorePasswordExists) {
            violations.add(new Violation(ViolationType.TRUST_STORE_PASSWORD_MISSING, Messages.getMessage("PropertyMissing", "TrustStorePassword"), CommonUtils.getSeverityAccordingToClient(this.initialCheck)));
            return violations;
        }
        if (isTrustStorePasswordNeeded && trustStorePasswordExists) {
            return violations;
        }
        return violations;
    }

    public void setCanBeEmpty(boolean canBeEmpty) {
        this.canBeEmpty = canBeEmpty;
    }
}

