/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class TrustStoreUtil {
    boolean isPropertyNeeded = false;
    ViolationSet violationSet = new ViolationSet();

    boolean isPropertyNeeded() {
        return this.isPropertyNeeded;
    }

    ViolationSet getViolationsOccurred() {
        return this.violationSet;
    }

    TrustStoreUtil(Properties properties, String trustStoreProperty, ViolationType trustStorePropertyRedundant) {
        this.violationSet.addSet(this.preparatoryChecks(properties, trustStoreProperty, trustStorePropertyRedundant));
    }

    ViolationSet preparatoryChecks(Properties properties, String trustStoreProperty, ViolationType trustStorePropertyRedundant) {
        String proxyType;
        ViolationSet violations = new ViolationSet();
        boolean trustStorePropertyExists = properties.containsKey(trustStoreProperty);
        boolean isHttpsUsed = false;
        boolean isProxyTypeInternet = true;
        boolean trustAll = false;
        if (!properties.containsKey("URL")) {
            violations.add(new Violation(ViolationType.URL_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "URL", trustStoreProperty), Severity.WARNING));
            return violations;
        }
        if (properties.containsKey("URL")) {
            String url = properties.getProperty("URL").trim();
            if (url.startsWith("https")) {
                isHttpsUsed = true;
            }
            if (!url.startsWith("https") && trustStorePropertyExists) {
                violations.add(new Violation(trustStorePropertyRedundant, Messages.getMessage("PropertyRedundantDueToUrl", trustStoreProperty), Severity.WARNING));
                return violations;
            }
        }
        if ((proxyType = properties.getProperty("ProxyType")) != null && !proxyType.trim().equals("Internet")) {
            isProxyTypeInternet = false;
        }
        if (!isProxyTypeInternet && trustStorePropertyExists) {
            violations.add(new Violation(trustStorePropertyRedundant, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", trustStoreProperty, "ProxyType", "Internet"), Severity.WARNING));
            return violations;
        }
        if (properties.containsKey("TrustAll")) {
            String trustAllValue = properties.getProperty("TrustAll").trim();
            if (trustAllValue.toLowerCase().equals("true")) {
                trustAll = true;
            }
            if (trustAll && trustStorePropertyExists) {
                violations.add(new Violation(trustStorePropertyRedundant, Messages.getMessage("TrustAllCausesPropertyRedundant", trustStoreProperty), Severity.WARNING));
                return violations;
            }
        }
        if (isHttpsUsed && isProxyTypeInternet && !trustAll) {
            this.isPropertyNeeded = true;
        }
        return violations;
    }
}

