/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http.consts;

import com.sap.core.utils.destinations.validation.utils.CommonConstants;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public abstract class HttpConstants
extends CommonConstants {
    public static final String HTTP_KEY_REGEX_START = "^[a-zA-Z].*$";
    public static final String HTTP_KEY_REGEX_CONTENT = "[a-zA-Z][a-zA-Z0-9-_\\.]*";
    public static final String PROXY_TYPE = "ProxyType";
    public static final String PROXY_TYPE_INTERNET = "Internet";
    public static final String PROXY_TYPE_ON_PREMISE = "OnPremise";
    public static final String PROXY_TYPE_INTERNAL = "Internal";
    public static final Set<String> proxyTypesAllowed = new HashSet<String>();
    public static final String SUFFIX = "://";
    public static final String URL = "URL";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String HTTP_PREFIX = "http://";
    public static final String HTTPS_PREFIX = "https://";
    public static Set<String> ALLOWED_PROTOCOLS;
    public static final String AUTHENTICATION = "Authentication";
    public static final String NO_AUTHENTICATION = "NoAuthentication";
    public static final String BASIC_AUTHENTICATION = "BasicAuthentication";
    public static final String CLIENT_CERTIFICATE_AUTHENTICATION = "ClientCertificateAuthentication";
    public static final String SAP_ASSERTION_SSO = "SAPAssertionSSO";
    public static final String APP_TO_APP_SSO = "AppToAppSSO";
    public static final String INTERNAL_SYSTEM_AUTHENTICATION = "InternalSystemAuthentication";
    public static final String PRINCIPAL_PROPAGATION = "PrincipalPropagation";
    public static final String OAUTH_2_SAML_BEARER_ASSERTION = "OAuth2SAMLBearerAssertion";
    public static Set<String> allowedTypesOfAuthentication;
    public static Set<String> allowedTypesOfAuthenticationFromIDE;
    public static final String USER = "User";
    public static final String PASSWORD = "Password";
    public static final String PREEMPTIVE = "Preemptive";
    public static final String SID_REGEX = "[a-zA-Z]{3}";
    public static final String CLIENT_REGEX = "[0-9]{3}";
    public static final String NOT_EMPTY_REGEX = ".*\\S.*";
    public static final String ISSUER_SID = "IssuerSID";
    public static final String RECIPIENT_SID = "RecipientSID";
    public static final String ISSUER_CLIENT = "IssuerClient";
    public static final String RECIPIENT_CLIENT = "RecipientClient";
    public static final String CERTIFICATE = "Certificate";
    public static final String SIGNING_KEY = "SigningKey";
    public static final String TRUST_ALL = "TrustAll";
    public static final String HOSTNAME_VERIFIER = "HostnameVerifier";
    public static final String HOSTNAME_VERIFIER_STRICT = "Strict";
    public static final String HOSTNAME_VERIFIER_BROWSER_COMPATIBLE = "BrowserCompatible";
    public static final Set<String> hostnameVerifiersAllowed;
    public static final String KEY_STORE_LOCATION = "KeyStoreLocation";
    public static final String KEY_STORE_PASSWORD = "KeyStorePassword";
    public static final String TRUST_STORE_LOCATION = "TrustStoreLocation";
    public static final String TRUST_STORE_PASSWORD = "TrustStorePassword";
    public static final String CLOUD_CONNECTOR_VERSION = "CloudConnectorVersion";
    public static final String CLOUD_CONNECTOR_VERSION_1 = "1";
    public static final String CLOUD_CONNECTOR_VERSION_2 = "2";
    public static final String AUDIENCE = "audience";
    public static final String CLIENT_KEY = "clientKey";
    public static final String TOKEN_SERVICE_URL = "tokenServiceURL";
    public static final String TOKEN_SERVICE_USER = "tokenServiceUser";
    public static final String TOKEN_SERVICE_PASSWORD = "tokenServicePassword";
    public static final String SYSTEM_USER = "SystemUser";
    public static final String NAME_QUALIFIER = "nameQualifier";
    public static final String COMPANY_ID = "companyId";
    public static final String ASSERTION_ISSUER = "assertionIssuer";
    public static final String SCOPE = "scope";
    public static final Set<String> allowedCloudConnectorVersions;
    public static final Set<String> allowedKeyStoreExtensions;
    public static final Set<String> allowedTrustStoreExtensions;
    public static final Set<String> allowedExtensions;

    static {
        Collections.addAll(proxyTypesAllowed, PROXY_TYPE_INTERNET, PROXY_TYPE_ON_PREMISE);
        ALLOWED_PROTOCOLS = new HashSet<String>();
        Collections.addAll(ALLOWED_PROTOCOLS, HTTP, HTTPS);
        allowedTypesOfAuthentication = new HashSet<String>();
        Collections.addAll(allowedTypesOfAuthentication, NO_AUTHENTICATION, BASIC_AUTHENTICATION, CLIENT_CERTIFICATE_AUTHENTICATION, SAP_ASSERTION_SSO, APP_TO_APP_SSO, PRINCIPAL_PROPAGATION, OAUTH_2_SAML_BEARER_ASSERTION);
        allowedTypesOfAuthenticationFromIDE = new HashSet<String>();
        Collections.addAll(allowedTypesOfAuthenticationFromIDE, NO_AUTHENTICATION, BASIC_AUTHENTICATION, CLIENT_CERTIFICATE_AUTHENTICATION, PRINCIPAL_PROPAGATION);
        hostnameVerifiersAllowed = new HashSet<String>();
        Collections.addAll(hostnameVerifiersAllowed, HOSTNAME_VERIFIER_STRICT, HOSTNAME_VERIFIER_BROWSER_COMPATIBLE);
        allowedCloudConnectorVersions = new TreeSet<String>();
        allowedKeyStoreExtensions = new HashSet<String>();
        allowedTrustStoreExtensions = new HashSet<String>();
        allowedExtensions = new HashSet<String>();
        Collections.addAll(allowedCloudConnectorVersions, CLOUD_CONNECTOR_VERSION_1, CLOUD_CONNECTOR_VERSION_2);
        Collections.addAll(allowedKeyStoreExtensions, "jks", "p12", "pfx");
        Collections.addAll(allowedTrustStoreExtensions, "jks", "crt", "cer", "der");
        Collections.addAll(allowedExtensions, "props", "properties", "txt");
        allowedExtensions.addAll(allowedKeyStoreExtensions);
        allowedExtensions.addAll(allowedTrustStoreExtensions);
    }
}

