/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.ldap;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.utils.ValidValuesFormatter;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.validators.ldap.consts.LdapConstants;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class LdapAuthenticationValidator
extends BasicPropertiesValidator {
    public LdapAuthenticationValidator() {
        super("ldap.authentication", true, ViolationType.AUTHENTICATION_MISSING, false);
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = super.proceedValidation(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        String value = properties.getProperty("ldap.authentication").trim();
        if ("BasicAuthentication".equals(value)) {
            this.validateBasicAuthenticationProperties(properties, "ldap.password", ViolationType.PASSWORD_MISSING, violations);
            this.validateBasicAuthenticationProperties(properties, "ldap.user", ViolationType.USER_MISSING, violations);
        } else if (!"NoAuthentication".equals(value)) {
            violations.add(new Violation(ViolationType.AUTHENTICATION_NOT_VALID, Messages.getMessage("LdapUnsupportedAuthentication", ValidValuesFormatter.format(LdapConstants.ALLOWED_AUTHN_TYPES)), Severity.ERROR));
        }
        return violations;
    }

    private void validateBasicAuthenticationProperties(Properties properties, String propertyKey, ViolationType violationType, ViolationSet violations) {
        BasicPropertiesValidator validator = new BasicPropertiesValidator(propertyKey, true, violationType, false);
        violations.addSet(validator.validate(properties));
    }
}

