/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.ldap;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class LdapCalculatedPropertiesValidator
extends Validator {
    public static final Set<String> CALCULATED_PROPERTIES = new HashSet<String>();
    public static final String KEY_SOCKET_FACTORY = "java.naming.ldap.factory.socket";

    static {
        CALCULATED_PROPERTIES.add("java.naming.provider.url");
        CALCULATED_PROPERTIES.add("java.naming.security.principal");
        CALCULATED_PROPERTIES.add("java.naming.security.credentials");
        CALCULATED_PROPERTIES.add("java.naming.security.authentication");
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        for (String propKey : CALCULATED_PROPERTIES) {
            if (properties.getProperty(propKey) == null) continue;
            violations.add(new Violation(ViolationType.LDAP_NAMESPACE_COLLISION, Messages.getMessage("LdapNamespaceCollision", propKey), Severity.ERROR));
        }
        if ("OnPremise".equals(properties.getProperty("ldap.proxyType")) && properties.getProperty(KEY_SOCKET_FACTORY) != null) {
            violations.add(new Violation(ViolationType.LDAP_NAMESPACE_COLLISION, Messages.getMessage("LdapNamespaceCollision", KEY_SOCKET_FACTORY), Severity.ERROR));
        }
        return violations;
    }
}

