/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.ldap;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.utils.ValidValuesFormatter;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.validators.ldap.consts.LdapConstants;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class LdapProxyTypeValidator
extends BasicPropertiesValidator {
    public LdapProxyTypeValidator() {
        super("ldap.proxyType", true, ViolationType.PROPERTY_VALUE_MISSING, false);
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = super.proceedValidation(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        String value = properties.getProperty("ldap.proxyType").trim();
        if (!LdapConstants.ALLOWED_PROXY_TYPES.contains(value)) {
            violations.add(new Violation(ViolationType.PROXY_TYPE_NOT_VALID, Messages.getMessage("ValueIsNotInAllowedRange", value, "ldap.proxyType", ValidValuesFormatter.format(LdapConstants.ALLOWED_PROXY_TYPES)), Severity.ERROR));
        }
        return violations;
    }
}

