/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.ldap;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;
import java.util.StringTokenizer;

public class LdapUrlValidator
extends BasicPropertiesValidator {
    private static final String LDAP_URL_SCHEME = "ldap://";

    public LdapUrlValidator() {
        super("ldap.url", true, ViolationType.URL_MISSING, false);
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = super.proceedValidation(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        if (!properties.containsKey("ldap.url") || properties.getProperty("ldap.url").trim().isEmpty()) {
            violations.add(new Violation(ViolationType.URL_MISSING, Messages.getMessage("PropertyMissing", "ldap.url"), Severity.ERROR));
            return violations;
        }
        String propValue = properties.getProperty("ldap.url");
        StringTokenizer st = new StringTokenizer(propValue, " ");
        while (st.hasMoreElements()) {
            if (st.nextToken().trim().toLowerCase().startsWith(LDAP_URL_SCHEME)) continue;
            violations.add(new Violation(ViolationType.LDAP_UNSUPPORTED_URL_PROTOCOL, Messages.getMessage("LdapUnsupportedURLProtocol", new Object[0]), Severity.ERROR));
        }
        return violations;
    }
}

