/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.rfc;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class RfcClientValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        String clientValue;
        ViolationSet violations = new ViolationSet();
        BasicPropertiesValidator validator = new BasicPropertiesValidator("jco.client.client", true, ViolationType.RFC_MISSING_PARAMETER, false);
        violations.addSet(validator.validate(properties));
        if (!violations.hasErrors() && !(clientValue = properties.getProperty("jco.client.client").trim()).matches("\\d{3}")) {
            violations.add(new Violation(ViolationType.RFC_CLIENT_VALUE_NOT_VALID, Messages.getMessage("RfcNotValidFormat", "jco.client.client", 3), Severity.ERROR));
        }
        return violations;
    }
}

