/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.rfc;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class RfcMessageServerHostValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        if (properties.containsKey("jco.client.mshost") && !properties.containsKey("jco.client.ashost")) {
            BasicPropertiesValidator validator = new BasicPropertiesValidator("jco.client.mshost", false, ViolationType.RFC_MISSING_PARAMETER, false);
            violations.addSet(validator.validate(properties));
            if (!violations.hasErrors()) {
                boolean isR3nameSet = properties.containsKey("jco.client.r3name");
                boolean isMsserverSet = properties.containsKey("jco.client.msserv");
                if (isR3nameSet && isMsserverSet) {
                    violations.add(new Violation(ViolationType.RFC_MSSERV_PORT_REDUNDANT, Messages.getMessage("TwoPropertiesSpecifiedAtSameTime", "jco.client.r3name", "jco.client.msserv"), Severity.WARNING));
                } else if (!isR3nameSet && !isMsserverSet) {
                    violations.add(new Violation(ViolationType.RFC_MSSERV_PORT_MISSING, Messages.getMessage("NoPropertyIsSpecify", "jco.client.r3name", "jco.client.msserv"), Severity.ERROR));
                }
            }
        }
        return violations;
    }
}

