/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.rfc;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class RfcMessageServerNameValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        if (properties.containsKey("jco.client.mshost") && properties.containsKey("jco.client.r3name")) {
            String value;
            BasicPropertiesValidator validator = new BasicPropertiesValidator("jco.client.r3name", false, ViolationType.RFC_MISSING_PARAMETER, false);
            violations.addSet(validator.validate(properties));
            if (!violations.hasErrors() && !(value = properties.getProperty("jco.client.r3name").trim()).matches("[a-zA-Z][a-zA-Z0-9]{2}")) {
                violations.add(new Violation(ViolationType.RFC_R3NAME_VALUE_NOT_VALID, Messages.getMessage("RfcNotValidCharFormat", "jco.client.r3name", 3), Severity.ERROR));
            }
        }
        return violations;
    }
}

