/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.rfc;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.validators.rfc.consts.RfcConstants;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class RfcPasswordValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        String passValue;
        ViolationSet violations = new ViolationSet();
        if (!properties.containsKey("jco.client.user")) {
            return violations;
        }
        BasicPropertiesValidator validator = new BasicPropertiesValidator("jco.client.passwd", true, ViolationType.RFC_MISSING_PARAMETER, false);
        violations.addSet(validator.validate(properties));
        if (!violations.hasErrors() && (passValue = properties.getProperty("jco.client.passwd")).length() > RfcConstants.MAX_RFC_PASSWD_LENGTH) {
            violations.add(new Violation(ViolationType.RFC_TOO_LONG_PASS, Messages.getMessage("RfcPasswdTooLong", "jco.client.passwd"), Severity.ERROR));
        }
        return violations;
    }
}

