/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.rfc;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class RfcSystemNumberValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        if (properties.containsKey("jco.client.ashost")) {
            String value;
            BasicPropertiesValidator sysNRValidator = new BasicPropertiesValidator("jco.client.sysnr", true, ViolationType.RFC_MISSING_PARAMETER, false);
            violations.addSet(sysNRValidator.validate(properties));
            if (!violations.hasErrors() && !(value = properties.getProperty("jco.client.sysnr").trim()).matches("\\d{2}")) {
                violations.add(new Violation(ViolationType.RFC_SYSNR_VALUE_NOT_VALID_FORMAT, Messages.getMessage("RfcNotValidFormat", "jco.client.sysnr", 2), Severity.ERROR));
            }
        }
        return violations;
    }
}

