/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.rfc;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class RfcTargetHostValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        boolean isAsHostSet = properties.containsKey("jco.client.ashost");
        boolean isMsHostSet = properties.containsKey("jco.client.mshost");
        if (!isAsHostSet && !isMsHostSet) {
            violations.add(new Violation(ViolationType.RFC_TARGET_HOST_MISSING, Messages.getMessage("NoPropertyIsSpecify", "jco.client.ashost", "jco.client.mshost"), Severity.ERROR));
        }
        if (isAsHostSet && isMsHostSet) {
            violations.add(new Violation(ViolationType.RFC_TARGET_HOST_MISSING, Messages.getMessage("TwoPropertiesSpecifiedAtSameTime", "jco.client.ashost", "jco.client.mshost"), Severity.ERROR));
        }
        return violations;
    }
}

