/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.rfc.optionalProperties;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class PositiveIntegerHelperValidator
extends Validator {
    private String key;

    public PositiveIntegerHelperValidator(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter key cannot be null");
        }
        this.key = key;
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        BasicPropertiesValidator basicValidator = new BasicPropertiesValidator(this.key, false, ViolationType.RFC_MISSING_PARAMETER, false);
        violations.addSet(basicValidator.validate(properties));
        if (violations.hasErrors()) {
            return violations;
        }
        if (!properties.containsKey(this.key)) {
            return violations;
        }
        String value = properties.getProperty(this.key).trim();
        if (!value.matches("(0|[1-9][0-9]*)")) {
            violations.add(new Violation(ViolationType.RFC_POOLING_PROPERTY_DOES_NOT_MATCH_REGEX, Messages.getMessage("RfcOptionalPositiveIntegerPropertyNotValid", this.key), Severity.ERROR));
        }
        return violations;
    }
}

