/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.rfc.optionalProperties;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class RfcClientCodePageValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        BasicPropertiesValidator basicValidator = new BasicPropertiesValidator("jco.client.codepage", false, ViolationType.RFC_MISSING_PARAMETER, false);
        violations.addSet(basicValidator.validate(properties));
        if (violations.hasErrors()) {
            return violations;
        }
        if (!properties.containsKey("jco.client.codepage")) {
            return violations;
        }
        String value = properties.getProperty("jco.client.codepage").trim();
        if (!value.matches("[0-9]{4}")) {
            violations.add(new Violation(ViolationType.RFC_CODEPAGE_DOES_NOT_MATCH_REGEX, Messages.getMessage("RfcNotValidFormat", "jco.client.codepage", 4), Severity.ERROR));
        }
        return violations;
    }
}

