/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.rfc.optionalProperties;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class RfcClientGroupValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        if (properties.containsKey("jco.client.group") && !properties.containsKey("jco.client.mshost")) {
            violations.add(new Violation(ViolationType.RFC_CLIENT_GROUP_REDUNDANT, Messages.getMessage("PropertyRedundant", "jco.client.group"), Severity.WARNING));
        }
        if (violations.hasWarnings()) {
            return violations;
        }
        BasicPropertiesValidator basicValidator = new BasicPropertiesValidator("jco.client.group", false, ViolationType.RFC_MISSING_PARAMETER, false);
        violations.addSet(basicValidator.validate(properties));
        return violations;
    }
}

