/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.rfc.optionalProperties;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class RfcClientLangValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        BasicPropertiesValidator basicValidator = new BasicPropertiesValidator("jco.client.lang", false, ViolationType.RFC_MISSING_PARAMETER, false);
        violations.addSet(basicValidator.validate(properties));
        if (violations.hasErrors()) {
            return violations;
        }
        if (!properties.containsKey("jco.client.lang")) {
            return violations;
        }
        String value = properties.getProperty("jco.client.lang").trim();
        boolean matchesFirstFormat = value.matches("[a-zA-Z]{2}");
        boolean matchesSecondFormat = value.matches("[a-zA-Z0-9]");
        if (!matchesFirstFormat && !matchesSecondFormat) {
            violations.add(new Violation(ViolationType.RFC_LANG_NOT_VALID, Messages.getMessage("RfcLangNotValidFormat", "jco.client.lang", 2, 1), Severity.ERROR));
        }
        return violations;
    }
}

