/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.rfc.optionalProperties;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.validators.rfc.consts.RfcConstants;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class RfcRepositoryPasswdValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        if (properties.containsKey("jco.destination.repository.user")) {
            BasicPropertiesValidator basicValidator = new BasicPropertiesValidator("jco.destination.repository.passwd", true, ViolationType.RFC_MISSING_PARAMETER, false);
            violations.addSet(basicValidator.validate(properties));
            if (violations.hasErrors()) {
                return violations;
            }
            String value = properties.getProperty("jco.destination.repository.passwd");
            if (value.length() > RfcConstants.MAX_RFC_PASSWD_LENGTH) {
                violations.add(new Violation(ViolationType.RFC_TOO_LONG_PASS, Messages.getMessage("RfcPasswdTooLong", "jco.destination.repository.passwd"), Severity.ERROR));
            }
            return violations;
        }
        if (properties.containsKey("jco.destination.repository.passwd")) {
            violations.add(new Violation(ViolationType.RFC_REPOSITORY_PASSWD_REDUNDANT, Messages.getMessage("PropertyRedundant", "jco.destination.repository.passwd"), Severity.WARNING));
        }
        return violations;
    }
}

