/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.violations;

import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ViolationSet {
    private Set<Violation> warnings = new LinkedHashSet<Violation>();
    private Set<Violation> errors = new LinkedHashSet<Violation>();

    public void add(Violation violation) {
        switch (violation.getSeverity()) {
            case ERROR: {
                this.errors.add(violation);
                break;
            }
            case WARNING: {
                this.warnings.add(violation);
            }
        }
    }

    public Set<Violation> getErrors() {
        return this.errors;
    }

    public List<ViolationType> getErrorViolationTypes() {
        return this.extractViolationTypes(this.errors);
    }

    public List<ViolationType> getWarningViolationTypes() {
        return this.extractViolationTypes(this.warnings);
    }

    public Set<Violation> getWarnings() {
        return this.warnings;
    }

    public void addSet(ViolationSet set) {
        this.errors.addAll(set.getErrors());
        this.warnings.addAll(set.getWarnings());
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public Set<Violation> getAll() {
        HashSet<Violation> allViolations = new HashSet<Violation>();
        allViolations.addAll(this.getErrors());
        allViolations.addAll(this.getWarnings());
        return allViolations;
    }

    public String toString() {
        return "Errors: " + Arrays.toString(this.errors.toArray()) + "\n" + "Warnings: " + Arrays.toString(this.warnings.toArray());
    }

    private List<ViolationType> extractViolationTypes(Set<Violation> violations) {
        ArrayList<ViolationType> result = new ArrayList<ViolationType>();
        for (Violation singleViolation : violations) {
            result.add(singleViolation.getType());
        }
        return result;
    }
}

