/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.infrastructure.validation;

import com.sap.core.utils.infrastructure.validation.LandscapeHostValidator;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class HttpResponseValidator
implements HttpResponseInterceptor {
    private static final Logger LOGGER = Logger.getLogger(HttpResponseValidator.class.getCanonicalName());
    private URL landscapeURL;

    public HttpResponseValidator(URL landscapeURL) {
        this.landscapeURL = landscapeURL;
    }

    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        boolean authRequestHeaderDetected;
        this.logResponse(httpResponse);
        boolean bl = authRequestHeaderDetected = httpContext.getAttribute("propAuthRequestHeaderDetected") != null;
        if (authRequestHeaderDetected) {
            httpContext.removeAttribute("propAuthRequestHeaderDetected");
        }
        LandscapeHostValidator.validateHttpResponseStatus(httpResponse, this.landscapeURL, true, true, !authRequestHeaderDetected);
    }

    private void logResponse(HttpResponse httpResponse) throws IOException {
        if (LOGGER.getLevel() != null && Level.FINE.equals(LOGGER.getLevel())) {
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            StringBuilder s = new StringBuilder("Response for " + this.landscapeURL.getHost() + ":" + this.landscapeURL.getPort() + " is: ");
            s.append(System.getProperty("line.separator"));
            s.append(String.valueOf(this.landscapeURL.toString()) + ":");
            s.append(String.valueOf(statusCode) + ":");
            s.append(httpResponse.getStatusLine().toString());
            s.append(System.getProperty("line.separator"));
            LOGGER.log(Level.FINE, s.toString());
        }
    }
}

