/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.infrastructure.validation;

import com.sap.core.utils.infrastructure.validation.AuthHeatherDetector;
import com.sap.core.utils.infrastructure.validation.AuthenticationException;
import com.sap.core.utils.infrastructure.validation.HostValidationException;
import com.sap.core.utils.infrastructure.validation.HttpResponseValidator;
import com.sap.core.utils.infrastructure.validation.NoSAPCertificateFoundException;
import com.sap.core.utils.infrastructure.validation.NoSSLConnectionException;
import com.sap.core.utils.infrastructure.validation.Severity;
import com.sap.core.utils.infrastructure.validation.ValidationStatus;
import com.sap.core.utils.infrastructure.validation.certificate.CertificatesFinder;
import com.sap.core.utils.infrastructure.validation.i18n.Messages;
import com.sap.core.utils.security.logon.BasicAuthHttpClientProvider;
import com.sap.core.utils.security.logon.LogonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;

public class LandscapeHostValidator {
    public static final String MAINTENANCE_MODE_MESSAGE = Messages.LandscapeHostValidator_MAINTENANCE_MODE_MESSAGE;
    public static final String MAINTENANCE_MODE_MESSAGE_WITHOUT_MINUTES = Messages.LandscapeHostValidator_MAINTENANCE_MODE_MESSAGE_WITHOUT_MINUTES;
    public static final String MAINTENANCE_MODE_MESSAGE_UNKNOWN_RETRY_AFTER = Messages.LandscapeHostValidator_MAINTENANCE_MODE_MESSAGE_UNKNOWN_RETRY_AFTER;
    public static final String CERTMANAGER_MAINTENANCE_MODE_MESSAGE = Messages.LandscapeHostValidator_CERTMANAGER__MAINTENANCE_MODE_MESSAGE;
    public static final String CERTMANAGER_MAINTENANCE_MODE_MESSAGE_WITHOUT_MINUTES = Messages.LandscapeHostValidator_CERTMANAGER__MAINTENANCE_MODE_MESSAGE_WITHOUT_MINUTES;
    public static final String CERTMANAGER_MAINTENANCE_MODE_MESSAGE_UNKNOWN_RETRY_AFTER = Messages.LandscapeHostValidator_CERTMANAGER__MAINTENANCE_MODE_MESSAGE_UNKNOWN_RETRY_AFTER;
    public static final String GLOBAL_THROTTLING_MODE_MESSAGE = Messages.LandscapeHostValidator_GLOBAL_THROTTLING_MODE;
    private static final String ERROR_URL_RETURNED_503_SERVICE_UNAVAILABLE = "Requested URL {0} returned: 503 - Service Unavailable";
    public static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 3);
    public static final int MAINTENANCE_MODE_REASON_CODE = 1001;
    public static final int CERTMANAGER_MAINTENANCE_MODE_REASON_CODE = 1002;
    public static final String RESPONSE_HEADER_SAP_REASON_CODE = "SAP-Reason-Code";
    public static final String RESPONSE_HEADER_SAP_RETRY_AFTER = "SAP-Retry-After";
    public static final String ATTR_AUTH_REQUEST_HEADER_DETECTED = "propAuthRequestHeaderDetected";
    private static final int PORT_S2S = 8443;
    private static final int PORT_HTTPS = 443;
    private static final Logger LOGGER = Logger.getLogger(LandscapeHostValidator.class.getCanonicalName());
    private static final String HTTPS_PROTOCOL = "https";
    public static final String HOST_ALIAS = "/";
    public static final int SOCKET_TIMEOUT = 20000;
    private static final long RETRY_INTERVAL = 1500L;
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static String validHostnameRegex = "^([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])(\\.([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]))*$";
    private static Pattern regExPatternHost = Pattern.compile(validHostnameRegex);
    private static String validIPRegex = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
    private static Pattern regExPatternIP = Pattern.compile(validIPRegex);
    public static final String MSG_GENERAL_ERROR = Messages.LandscapeHostValidator_general_error;

    public static ValidationStatus checkConnectionToLandscapeHost(URL landscapeURL, String alias) {
        return LandscapeHostValidator.checkConnectionToLandscapeHost(landscapeURL, alias, 20000);
    }

    public static ValidationStatus checkConnectionToLandscapeHost(URL landscapeURL, String alias, int socketTimeout) {
        return LandscapeHostValidator.checkConnectionToLandscapeHost(landscapeURL, alias, socketTimeout, false);
    }

    public static ValidationStatus checkConnectionToLandscapeHost(URL landscapeURL, String alias, int socketTimeout, boolean matchWildCard) {
        if (landscapeURL == null) {
            throw new IllegalArgumentException("No Landscape URL");
        }
        DefaultHttpClient defaultHttpClient = null;
        try {
            URL landscapeURLForCertificate = landscapeURL;
            if (landscapeURL.getPort() == 8443) {
                landscapeURLForCertificate = new URL(landscapeURL.getProtocol(), landscapeURL.getHost(), 443, landscapeURL.getFile());
            }
            defaultHttpClient = (DefaultHttpClient)LandscapeHostValidator.getHttpClient(landscapeURLForCertificate, alias, socketTimeout, matchWildCard);
            HttpHost target = new HttpHost(landscapeURL.getHost(), landscapeURL.getPort(), landscapeURL.getProtocol());
            HttpGet req = new HttpGet(alias);
            defaultHttpClient.execute(target, (HttpRequest)req);
            ValidationStatus validationStatus = new ValidationStatus(Severity.OK, null);
            return validationStatus;
        }
        catch (UnknownHostException e) {
            ValidationStatus validationStatus = new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.LandscapeHostValidator_incorrect_proxy_settings, landscapeURL.toString()), (Exception)e.getCause());
            return validationStatus;
        }
        catch (SSLException e) {
            ValidationStatus validationStatus = new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.LandscapeHostValidator_SSLPeerUnverifiedException, landscapeURL.toString()), (Exception)e.getCause());
            return validationStatus;
        }
        catch (SocketTimeoutException e) {
            ValidationStatus validationStatus = new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.LandscapeHostValidator_no_response, landscapeURL.toString()), (Exception)e.getCause());
            return validationStatus;
        }
        catch (ConnectException e) {
            ValidationStatus validationStatus = new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.LandscapeHostValidator_incorrect_proxy_settings, landscapeURL.toString()), (Exception)e.getCause());
            return validationStatus;
        }
        catch (SocketException e) {
            ValidationStatus validationStatus = new ValidationStatus(Severity.ERROR, Messages.LandscapeHostValidator_connection_reset, (Exception)e.getCause());
            return validationStatus;
        }
        catch (ClientProtocolException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSAPCertificateFoundException || cause instanceof NoSSLConnectionException || cause instanceof HttpException) {
                ValidationStatus validationStatus = new ValidationStatus(Severity.ERROR, cause.getMessage(), (Exception)cause);
                return validationStatus;
            }
            ValidationStatus validationStatus = new ValidationStatus(Severity.ERROR, e.getMessage(), (Exception)cause);
            return validationStatus;
        }
        catch (HostValidationException e) {
            ValidationStatus validationStatus = new ValidationStatus(Severity.ERROR, e.getValidationErrorMessage(), (Exception)e.getCause());
            return validationStatus;
        }
        catch (Exception e) {
            ValidationStatus validationStatus = new ValidationStatus(Severity.ERROR, e.getMessage(), e);
            return validationStatus;
        }
        finally {
            if (defaultHttpClient != null) {
                defaultHttpClient.getConnectionManager().shutdown();
            }
        }
    }

    public static HttpClient getHttpClient(URL landscapeURL, String username, String password) throws HostValidationException, IOException {
        return LandscapeHostValidator.getHttpClient(landscapeURL, HOST_ALIAS, 20000, username, password, false);
    }

    public static HttpClient getHttpClient(URL landscapeURL, String alias, String username, String password) throws HostValidationException, IOException {
        return LandscapeHostValidator.getHttpClient(landscapeURL, alias, 20000, username, password, false);
    }

    public static HttpClient getHttpClient(URL landscapeURL, String alias, int socketTimeout, boolean matchWildCard) throws HostValidationException, IOException {
        return LandscapeHostValidator.getHttpClient(landscapeURL, alias, socketTimeout, null, null, matchWildCard);
    }

    public static HttpClient getHttpClient(URL landscapeURL, String alias, int socketTimeout, String username, String password, boolean matchWildCard) throws HostValidationException, IOException {
        if (landscapeURL == null) {
            throw new IllegalArgumentException("No Landscape URL");
        }
        DefaultHttpClient defaultHttpClient = null;
        try {
            if (username == null && password != null) {
                throw new IllegalArgumentException("User name should be specified if a password is provided");
            }
            if (password == null && username != null) {
                throw new IllegalArgumentException("Password should be specified if a user name is provided");
            }
            defaultHttpClient = (DefaultHttpClient)LogonUtils.createHttpClientWithoutAuth(landscapeURL.toString());
            HttpParams params = defaultHttpClient.getParams();
            params.setIntParameter("http.socket.timeout", socketTimeout);
            params.setBooleanParameter("http.protocol.handle-redirects", false);
            defaultHttpClient.setParams(params);
            CertificatesFinder certificatesFinder = new CertificatesFinder(landscapeURL.getHost(), matchWildCard);
            defaultHttpClient.addRequestInterceptor((HttpRequestInterceptor)certificatesFinder);
            AuthHeatherDetector authHeatherDetector = new AuthHeatherDetector();
            defaultHttpClient.addRequestInterceptor((HttpRequestInterceptor)authHeatherDetector);
            HttpHost target = new HttpHost(landscapeURL.getHost(), landscapeURL.getPort(), landscapeURL.getProtocol());
            HttpGet req = new HttpGet(alias);
            if (LOGGER.getLevel() != null && Level.FINE.equals(LOGGER.getLevel())) {
                Header[] allHeaders;
                StringBuilder s = new StringBuilder("Requested header(s) for " + landscapeURL.getHost() + ":" + landscapeURL.getPort() + " are: ");
                s.append(System.getProperty("line.separator"));
                Header[] headerArray = allHeaders = req.getAllHeaders();
                int n = allHeaders.length;
                int n2 = 0;
                while (n2 < n) {
                    Header header = headerArray[n2];
                    s.append(String.valueOf(header.getName()) + ":" + header.getValue() + ";");
                    s.append(System.getProperty("line.separator"));
                    ++n2;
                }
                LOGGER.log(Level.FINE, s.toString());
            }
            HttpResponse rsp = defaultHttpClient.execute(target, (HttpRequest)req);
            if (LOGGER.getLevel() != null && Level.FINE.equals(LOGGER.getLevel())) {
                int statusCode = rsp.getStatusLine().getStatusCode();
                StringBuilder s = new StringBuilder("Response for " + landscapeURL.getHost() + ":" + landscapeURL.getPort() + " is: ");
                s.append(System.getProperty("line.separator"));
                s.append(String.valueOf(landscapeURL.toString()) + ":");
                s.append(String.valueOf(statusCode) + ":");
                s.append(rsp.getStatusLine().toString());
                s.append(System.getProperty("line.separator"));
                LOGGER.log(Level.FINE, s.toString());
            }
            LandscapeHostValidator.consumeHttpResponse(rsp);
            HttpResponseValidator httpResponseValidator = new HttpResponseValidator(landscapeURL);
            defaultHttpClient.addResponseInterceptor((HttpResponseInterceptor)httpResponseValidator);
            BasicAuthHttpClientProvider.setAuthCredentials(defaultHttpClient, username, password);
        }
        catch (UnknownHostException e) {
            throw new HostValidationException(e, MessageFormat.format(Messages.LandscapeHostValidator_incorrect_proxy_settings, landscapeURL.toString()));
        }
        catch (SSLException e) {
            throw new HostValidationException(e, MessageFormat.format(Messages.LandscapeHostValidator_SSLPeerUnverifiedException, landscapeURL.toString()));
        }
        catch (SocketTimeoutException e) {
            throw new HostValidationException(e, MessageFormat.format(Messages.LandscapeHostValidator_no_response, landscapeURL.toString()));
        }
        catch (ConnectException e) {
            throw new HostValidationException(e, MessageFormat.format(Messages.LandscapeHostValidator_incorrect_proxy_settings, landscapeURL.toString()));
        }
        catch (SocketException e) {
            throw new HostValidationException(e, Messages.LandscapeHostValidator_connection_reset);
        }
        catch (ClientProtocolException e) {
            if (e.getCause() instanceof NoSAPCertificateFoundException || e.getCause() instanceof NoSSLConnectionException) {
                throw new HostValidationException((Exception)((Object)e), e.getCause().getMessage());
            }
            throw e;
        }
        return defaultHttpClient;
    }

    private static void consumeHttpResponse(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        try {
            InputStream inputStream;
            if (entity != null && entity.isStreaming() && (inputStream = entity.getContent()) != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            LandscapeHostValidator.logException(Level.FINE, e);
        }
    }

    public static void validateHttpResponseStatus(HttpResponse response, URL landscapeURL) throws HttpException, AuthenticationException {
        LandscapeHostValidator.validateHttpResponseStatus(response, landscapeURL, true, true);
    }

    public static void validateHttpResponseStatus(HttpResponse response, URL landscapeURL, boolean skipBadRequest, boolean skipUnauthorized) throws HttpException {
        LandscapeHostValidator.validateHttpResponseStatus(response, landscapeURL, skipBadRequest, false, skipUnauthorized);
    }

    public static void validateHttpResponseStatus(HttpResponse response, URL landscapeURL, boolean skipBadRequest, boolean skipISE, boolean skipUnauthorized) throws HttpException {
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 400: {
                if (skipBadRequest) break;
                throw new HttpException(MessageFormat.format(Messages.LandscapeHostValidator_erroneous_http_response, response.getStatusLine().toString(), landscapeURL.toString()));
            }
            case 401: {
                if (skipUnauthorized) break;
                throw new AuthenticationException(LogonUtils.getAuthenticationFailureErrorMessage(response));
            }
            case 500: {
                if (skipISE) break;
                throw new HttpException(MessageFormat.format(Messages.LandscapeHostValidator_erroneous_http_response, response.getStatusLine().toString(), landscapeURL.toString()));
            }
            case 503: {
                try {
                    String retryAfterHeader;
                    String headerValue = LandscapeHostValidator.getHeaderValue(response, RESPONSE_HEADER_SAP_REASON_CODE);
                    if (headerValue != null) {
                        int code = Integer.parseInt(headerValue);
                        if (code == 1001) {
                            LandscapeHostValidator.sendMaintenanceModeException(response, MAINTENANCE_MODE_MESSAGE, MAINTENANCE_MODE_MESSAGE_WITHOUT_MINUTES, MAINTENANCE_MODE_MESSAGE_UNKNOWN_RETRY_AFTER);
                        } else if (code == 1002) {
                            LandscapeHostValidator.sendMaintenanceModeException(response, CERTMANAGER_MAINTENANCE_MODE_MESSAGE, CERTMANAGER_MAINTENANCE_MODE_MESSAGE_WITHOUT_MINUTES, CERTMANAGER_MAINTENANCE_MODE_MESSAGE_UNKNOWN_RETRY_AFTER);
                        }
                    }
                    if ((retryAfterHeader = LandscapeHostValidator.getHeaderValue(response, "Retry-After")) != null) {
                        throw new HttpException(MessageFormat.format(GLOBAL_THROTTLING_MODE_MESSAGE, retryAfterHeader));
                    }
                    LOGGER.log(Level.SEVERE, MessageFormat.format(ERROR_URL_RETURNED_503_SERVICE_UNAVAILABLE, landscapeURL.toString()));
                    throw new HttpException(MessageFormat.format(Messages.LandscapeHostValidator_general_error, landscapeURL.toString()));
                }
                catch (NullPointerException e) {
                    LandscapeHostValidator.logException(Level.SEVERE, e);
                    throw new HttpException(MessageFormat.format(Messages.LandscapeHostValidator_general_error, landscapeURL.toString()));
                }
                catch (NumberFormatException e) {
                    LandscapeHostValidator.logException(Level.SEVERE, e);
                    throw new HttpException(MessageFormat.format(Messages.LandscapeHostValidator_general_error, landscapeURL.toString()));
                }
            }
        }
    }

    private static void sendMaintenanceModeException(HttpResponse response, String maitenanceModeMessage, String maitenanceModeMessageWithoutMinutes, String maitenanceModeMessageUnknown) throws HttpException {
        try {
            long retryAfter = Long.parseLong(LandscapeHostValidator.getHeaderValue(response, RESPONSE_HEADER_SAP_RETRY_AFTER));
            long retryAfterMinutes = TimeUnit.MILLISECONDS.toMinutes(retryAfter - System.currentTimeMillis());
            String date = DATE_FORMAT.format(new Date(retryAfter));
            String message = retryAfterMinutes > 0L ? MessageFormat.format(maitenanceModeMessage, retryAfterMinutes, date) : MessageFormat.format(maitenanceModeMessageWithoutMinutes, date);
            throw new HttpException(message);
        }
        catch (NullPointerException e) {
            LandscapeHostValidator.logException(Level.SEVERE, e);
            throw new HttpException(maitenanceModeMessageUnknown);
        }
        catch (NumberFormatException e) {
            LandscapeHostValidator.logException(Level.SEVERE, e);
            throw new HttpException(maitenanceModeMessageUnknown);
        }
    }

    private static void logException(Level level, Exception e) {
        if (LOGGER.getLevel() != null && LOGGER.getLevel().intValue() <= level.intValue()) {
            LOGGER.log(level, e.getMessage(), e);
        }
    }

    public static ValidationStatus checkLanscapeHostWithoutConnecting(String landscape) {
        String protocol = LandscapeHostValidator.getProtocol(landscape);
        String url = landscape;
        if (protocol == null) {
            url = "https://" + landscape;
        } else if (!HTTPS_PROTOCOL.equals(protocol)) {
            return new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.LandscapeHostValidator_no_https_protocol, landscape));
        }
        URL landscapeURL = null;
        try {
            landscapeURL = new URL(url);
        }
        catch (MalformedURLException e) {
            return new ValidationStatus(Severity.ERROR, Messages.LandscapeHostValidator_cannot_be_converted_to_uri, e);
        }
        String landscapeHost = landscapeURL.getHost();
        if (landscapeHost == null || landscapeHost.isEmpty()) {
            return new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.LandscapeHostValidator_cannot_be_converted_to_uri, landscape));
        }
        if (landscapeHost.length() > 255) {
            return new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.LandscapeHostValidator_incorrect_host_length, landscapeHost));
        }
        if (!LandscapeHostValidator.validHostName(landscapeHost) && !LandscapeHostValidator.validIP(landscapeHost)) {
            return new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.LandscapeHostValidator_incorrect_internet_host, landscapeHost));
        }
        return new ValidationStatus(Severity.OK, null, null);
    }

    public static ValidationStatus isLandscapeHostValid(String landscapeHost, String alias) {
        return LandscapeHostValidator.isLandscapeHostValid(landscapeHost, alias, 20000, true);
    }

    public static ValidationStatus isLandscapeHostValid(String landscapeHost, String alias, int socketTimeout, boolean noRetry) {
        return LandscapeHostValidator.isLandscapeHostValid(landscapeHost, alias, socketTimeout, noRetry, false);
    }

    public static ValidationStatus isLandscapeHostValid(String landscapeHost, String alias, int socketTimeout, boolean noRetry, boolean matchWildCard) {
        if (landscapeHost == null) {
            throw new IllegalArgumentException("No host specified");
        }
        try {
            String protocol = LandscapeHostValidator.getProtocol(landscapeHost);
            String url = landscapeHost;
            if (protocol == null) {
                url = "https://" + landscapeHost;
            } else if (!HTTPS_PROTOCOL.equals(protocol)) {
                return new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.LandscapeHostValidator_no_https_protocol, landscapeHost));
            }
            ValidationStatus validationStatus = LandscapeHostValidator.checkLanscapeHostWithoutConnecting(url);
            if (validationStatus.isError()) {
                return validationStatus;
            }
            URL landscapeURL = new URL(url);
            validationStatus = LandscapeHostValidator.checkConnectionToLandscapeHost(landscapeURL, alias, socketTimeout, matchWildCard);
            if (noRetry) {
                return validationStatus;
            }
            int retries = 1;
            while (retries <= 3 & validationStatus.isError()) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {}
                validationStatus = LandscapeHostValidator.checkConnectionToLandscapeHost(landscapeURL, alias, socketTimeout);
                ++retries;
            }
            return validationStatus;
        }
        catch (MalformedURLException e) {
            return new ValidationStatus(Severity.ERROR, Messages.LandscapeHostValidator_cannot_be_converted_to_uri, e);
        }
    }

    private static String getProtocol(String url) {
        int indexOfColon = url.indexOf(":");
        String protocol = null;
        if (indexOfColon != -1) {
            protocol = url.substring(0, indexOfColon);
        }
        return protocol;
    }

    private static boolean validHostName(String hostName) {
        return regExPatternHost.matcher(hostName).matches();
    }

    private static boolean validIP(String ip) {
        return regExPatternIP.matcher(ip).matches();
    }

    private static String getHeaderValue(HttpResponse response, String header) {
        Header firstHeader = response.getFirstHeader(header);
        return firstHeader == null ? null : firstHeader.getValue();
    }
}

