/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.infrastructure.validation;

import com.sap.core.utils.infrastructure.validation.Severity;
import com.sap.core.utils.infrastructure.validation.ValidationStatus;
import com.sap.core.utils.infrastructure.validation.i18n.Messages;
import java.text.MessageFormat;
import java.util.regex.Pattern;

public class SACNameValidator {
    private static final Pattern PATTERN_ALPHANUMERIC = Pattern.compile("^[A-Za-z][A-Za-z0-9]{0,29}$");
    private static final Pattern PATTERN_SIZE_IS_BETWEEN_1AND30 = Pattern.compile(".{1,30}$");
    private static final Pattern PATTERN_START_WITH_LETTER = Pattern.compile("^[A-Za-z].*");
    private static final Pattern PATTERN_ONLY_ALPHANUMERIC = Pattern.compile("[A-Za-z0-9]*");
    private static final Pattern PATTERN_TRIAL_ACCOUNT = Pattern.compile("([pcdis])(\\d+)(trial)", 2);
    public static final String VALIDATION_HINT_MESSAGE = MessageFormat.format(Messages.SACNameValidator_HINT_MESSAGE, Messages.SACNameValidator_ACCOUNT_NAME);

    public static boolean isSpaceValid(String spaceName) {
        return SACNameValidator.performValidation(spaceName, PATTERN_ALPHANUMERIC);
    }

    public static boolean isComponentValid(String componentName) {
        return SACNameValidator.performValidation(componentName, PATTERN_ALPHANUMERIC);
    }

    public static boolean isApplianceValid(String applianceName) {
        return SACNameValidator.performValidation(applianceName, PATTERN_ALPHANUMERIC);
    }

    public static boolean isShortURLValid(String shortURL) {
        return SACNameValidator.performValidation(shortURL, PATTERN_ALPHANUMERIC);
    }

    public static boolean isApplicationValid(String applicationName) {
        return SACNameValidator.isApplianceValid(applicationName);
    }

    public static boolean isAccountValid(String accountName) {
        return SACNameValidator.isSpaceValid(accountName);
    }

    public static boolean isTrialAccount(String accountName) {
        return SACNameValidator.performValidation(accountName, PATTERN_TRIAL_ACCOUNT);
    }

    public static ValidationStatus validateAccount(String accountName) {
        return SACNameValidator.validateSAC(Messages.SACNameValidator_ACCOUNT_NAME, accountName);
    }

    public static ValidationStatus validateComponent(String componentName) {
        return SACNameValidator.validateSAC(Messages.SACNameValidator_COMPONENT_NAME, componentName);
    }

    public static ValidationStatus validateApplication(String applicationName) {
        return SACNameValidator.validateSACWithWarningForCapitalLetters(Messages.SACNameValidator_APPLICATION_NAME, applicationName);
    }

    private static ValidationStatus validateSACWithWarningForCapitalLetters(String entityName, String entityValue) {
        ValidationStatus status = SACNameValidator.validateSAC(entityName, entityValue);
        if (!status.isError() && !entityValue.toLowerCase().equals(entityValue)) {
            return new ValidationStatus(Severity.WARNING, MessageFormat.format(Messages.SACNameValidator_HINT_MESSAGE_CONTAIN_LARGE_CASE, entityName));
        }
        return status;
    }

    private static ValidationStatus validateSAC(String entityName, String entityValue) {
        if (!SACNameValidator.performValidation(entityValue, PATTERN_ALPHANUMERIC)) {
            if (SACNameValidator.isEmpty(entityValue)) {
                return new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.SACNameValidator_HINT_MESSAGE_MUST_NOT_BE_EMPTY, entityName));
            }
            if (!SACNameValidator.isSizeBetween1And30(entityValue)) {
                return new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.SACNameValidator_HINT_MESSAGE_SIZE_IS_BETWEEN_1_AND_30, entityName));
            }
            if (!SACNameValidator.containsOnlyAlphaNumericLetters(entityValue)) {
                return new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.SACNameValidator_HINT_MESSAGE_CONTAIN_ONLY_ALPHANUMERIC, entityName));
            }
            if (!SACNameValidator.startsWithLetter(entityValue)) {
                return new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.SACNameValidator_HINT_MESSAGE_START_WITH_LETTER, entityName));
            }
            return new ValidationStatus(Severity.ERROR, MessageFormat.format(Messages.SACNameValidator_HINT_MESSAGE, entityName));
        }
        return new ValidationStatus(Severity.OK, null);
    }

    public static boolean isEmpty(String stringToCheck) {
        return stringToCheck == null || stringToCheck.trim().length() == 0;
    }

    public static boolean isSizeBetween1And30(String stringToCheck) {
        return SACNameValidator.performValidation(stringToCheck, PATTERN_SIZE_IS_BETWEEN_1AND30);
    }

    public static boolean startsWithLetter(String stringToCheck) {
        return SACNameValidator.performValidation(stringToCheck, PATTERN_START_WITH_LETTER);
    }

    public static boolean containsOnlyAlphaNumericLetters(String stringToCheck) {
        return SACNameValidator.performValidation(stringToCheck, PATTERN_ONLY_ALPHANUMERIC);
    }

    private static boolean performValidation(String input, Pattern pattern) {
        if (input == null || input.trim().isEmpty()) {
            return false;
        }
        return pattern.matcher(input).matches();
    }
}

