/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.infrastructure.validation;

import com.sap.core.utils.infrastructure.validation.Severity;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class ValidationStatus {
    private Severity severity;
    private String message;
    private Exception exception;

    public ValidationStatus(Severity severity, String message) {
        this(severity, message, null);
    }

    public ValidationStatus(Severity severity, String message, Exception exception) {
        this.severity = severity;
        this.message = message;
        this.exception = exception;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isError() {
        return Severity.ERROR == this.severity;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValidationStatus");
        sb.append("{severity=").append((Object)this.severity);
        sb.append(", message='").append(this.message).append('\'');
        if (this.exception != null) {
            ByteArrayOutputStream baos = null;
            PrintStream ps = null;
            try {
                baos = new ByteArrayOutputStream();
                ps = new PrintStream(baos);
                this.exception.printStackTrace(ps);
                sb.append(", exception=").append(new String(baos.toByteArray()));
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        } else {
            sb.append(", exception=null");
        }
        sb.append('}');
        return sb.toString();
    }
}

