/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.infrastructure.validation.certificate;

import com.sap.core.utils.infrastructure.validation.NoSAPCertificateFoundException;
import com.sap.core.utils.infrastructure.validation.certificate.providers.CertificateProvider;
import java.security.cert.Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class CertificateValidator {
    private static final Logger LOGGER = Logger.getLogger(CertificateValidator.class.getCanonicalName());
    public static final String COMMON_NAME_WILD_CARD = "*.";
    private static final String LOG_CERTIFICATE_MSG = "Certificate: {0}";
    private static final String LOG_CERTIFICATE_PROVIDER_MSG = "Certificate Provider: {0}";
    private static final String LOG_DOMAIN_NAME_MSG = "Domain name: {0}";
    private String host;
    private boolean matchWildCard;
    private String domainName;

    public CertificateValidator(String host, boolean matchWildCard) {
        this.host = host;
        this.matchWildCard = matchWildCard;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isMatchWildCard() {
        return this.matchWildCard;
    }

    public String getDomainName() throws NoSAPCertificateFoundException {
        if (this.domainName == null || this.domainName.trim().isEmpty()) {
            throw new NoSAPCertificateFoundException(this.getHost());
        }
        return this.domainName.startsWith(COMMON_NAME_WILD_CARD) ? this.domainName.substring(2) : this.domainName;
    }

    public boolean validateCertificate(SSLSession sslsession) throws SSLPeerUnverifiedException {
        Certificate[] certificates = sslsession.getPeerCertificates();
        if (certificates != null) {
            List<CertificateProvider> certificateProviders = CertificateProvider.getAllCertificateProviders();
            Certificate[] certificateArray = certificates;
            int n = certificates.length;
            int n2 = 0;
            while (n2 < n) {
                Certificate certificate = certificateArray[n2];
                this.fineLog(LOG_CERTIFICATE_MSG, certificate);
                for (CertificateProvider certificateProvider : certificateProviders) {
                    this.fineLog(LOG_CERTIFICATE_PROVIDER_MSG, certificateProvider);
                    if (certificateProvider == null || !certificateProvider.isValidSapCloudCertificate(certificate, this.getHost(), this.isMatchWildCard())) continue;
                    this.domainName = certificateProvider.getDomainName();
                    this.fineLog(LOG_DOMAIN_NAME_MSG, this.domainName);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void fineLog(String msg, Object params) {
        if (LOGGER.getLevel() != null && Level.FINE.equals(LOGGER.getLevel())) {
            LOGGER.log(Level.FINE, msg, params);
        }
    }
}

