/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.infrastructure.validation.certificate;

import com.sap.core.utils.infrastructure.validation.NoSAPCertificateFoundException;
import com.sap.core.utils.infrastructure.validation.NoSSLConnectionException;
import com.sap.core.utils.infrastructure.validation.certificate.CertificateValidator;
import java.io.IOException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.conn.HttpRoutedConnection;
import org.apache.http.protocol.HttpContext;

public class CertificatesFinder
implements HttpRequestInterceptor {
    private static final String HTTPS_CONNECT_REQUEST = "CONNECT";
    private CertificateValidator validator;

    public CertificatesFinder(String host, boolean matchWildCard) {
        this.validator = new CertificateValidator(host, matchWildCard);
    }

    public String getDomainName() throws NoSAPCertificateFoundException {
        return this.validator.getDomainName();
    }

    public void process(HttpRequest httpRequest, HttpContext context) throws HttpException, IOException {
        HttpRoutedConnection conn = (HttpRoutedConnection)context.getAttribute("http.connection");
        SSLSession sslsession = conn.getSSLSession();
        this.validate(httpRequest, sslsession);
    }

    private void validate(HttpRequest httpRequest, SSLSession sslsession) throws NoSSLConnectionException, SSLPeerUnverifiedException, NoSAPCertificateFoundException {
        if (httpRequest == null || !HTTPS_CONNECT_REQUEST.equals(httpRequest.getRequestLine().getMethod())) {
            if (sslsession == null) {
                throw new NoSSLConnectionException(this.validator.getHost());
            }
            if (!this.validator.validateCertificate(sslsession)) {
                throw new NoSAPCertificateFoundException(this.validator.getHost());
            }
        }
    }
}

