/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.infrastructure.validation.certificate.providers;

import com.sap.core.utils.infrastructure.validation.certificate.providers.CommonSAPCertificateProvider;
import java.io.IOException;
import java.io.StringReader;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class CertificateProvider {
    private static final String ATTRIBUTE_COMMON_NAME = "CN";
    private static final String ATTRIBUTE_ORGANIZATION = "O";
    private static final char DOT = '.';
    private static final Pattern COMMA_PATTERN = Pattern.compile("\\s*,\\s*");
    protected Logger logger = null;
    private String domainName = null;
    protected boolean ignoreCase = false;

    protected abstract String getSubjectOrganization();

    public String getDomainName() {
        return this.domainName;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(CertificateProvider.class.getCanonicalName());
        }
        return this.logger;
    }

    public static List<CertificateProvider> getAllCertificateProviders() {
        ArrayList<CertificateProvider> providers = new ArrayList<CertificateProvider>();
        providers.add(new CommonSAPCertificateProvider());
        return providers;
    }

    public boolean isValidSapCloudCertificate(Certificate certificate, String host, boolean matchWildCard) {
        if (certificate != null && certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            return this.hasMatchingHostName(x509Certificate, host, matchWildCard);
        }
        return false;
    }

    private boolean hasMatchingHostName(X509Certificate x509Certificate, String host, boolean matchWildCard) {
        this.domainName = this.extractDomainName(x509Certificate, host, matchWildCard);
        return this.domainName != null;
    }

    private String extractDomainName(X509Certificate x509Certificate, String host, boolean matchWildCard) {
        String extractedDomainName = null;
        Properties subjectProperties = this.getSubjectProperties(x509Certificate);
        if (this.containsProperty(subjectProperties, ATTRIBUTE_ORGANIZATION, this.getSubjectOrganization())) {
            String commonName = subjectProperties.getProperty(ATTRIBUTE_COMMON_NAME);
            extractedDomainName = commonName != null ? (this.hostMatches(commonName, host, matchWildCard) ? commonName : this.extractAlternativeName(x509Certificate, host, matchWildCard)) : this.extractAlternativeName(x509Certificate, host, matchWildCard);
        }
        return extractedDomainName;
    }

    private String extractAlternativeName(X509Certificate x509Certificate, String host, boolean matchWildCard) {
        String extractedName = null;
        try {
            Collection<List<?>> subjectAlternativeNames = x509Certificate.getSubjectAlternativeNames();
            if (subjectAlternativeNames != null) {
                for (List<?> objects : subjectAlternativeNames) {
                    if (objects.size() != 2) continue;
                    String alternativeName = String.valueOf(objects.get(1));
                    if ((Integer)objects.get(0) != 2 || !this.hostMatches(alternativeName, host, matchWildCard)) continue;
                    extractedName = alternativeName;
                }
            }
        }
        catch (CertificateParsingException e) {
            this.getLogger().log(Level.FINE, "Failed to get subjectAlternativeNames", e);
        }
        return extractedName;
    }

    private boolean containsProperty(Properties properties, String attributeName, String value) {
        String propertyValue = properties.getProperty(attributeName);
        return propertyValue != null && propertyValue.toLowerCase().contains(value.toLowerCase());
    }

    private boolean hostMatches(String name, String host, boolean matchWildCard) {
        boolean matches = false;
        if (matchWildCard && name.startsWith("*.")) {
            int indexOfDot = host.indexOf(46);
            if ((name = name.substring(2)).equalsIgnoreCase(host)) {
                matches = true;
            } else if (indexOfDot > 0) {
                String hostDomain = host.substring(indexOfDot + 1);
                matches = name.equalsIgnoreCase(hostDomain);
            }
        } else {
            matches = name.equalsIgnoreCase(host);
        }
        return matches;
    }

    private Properties getSubjectProperties(X509Certificate x509Certificate) {
        Properties properties = new Properties();
        Principal subjectDN = x509Certificate.getSubjectDN();
        if (subjectDN != null) {
            properties = this.loadPropertiesFromStringWithCommas(subjectDN.getName());
        }
        return properties;
    }

    private Properties loadPropertiesFromStringWithCommas(String string) {
        Properties properties = new Properties();
        StringBuilder sb = new StringBuilder();
        if (string != null) {
            for (String next : Arrays.asList(COMMA_PATTERN.split(string.trim()))) {
                sb.append(next).append("\n");
            }
            try {
                properties.load(new StringReader(sb.toString()));
            }
            catch (IOException e) {
                this.getLogger().log(Level.FINE, "Failed to load PropertiesFromStringWithCommas", e);
            }
        }
        return properties;
    }
}

