/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.sdk.status;

import java.text.MessageFormat;

public enum RuntimeType {
    NEO_JAVA_WEB("neo-java-web", "neo-java-web", 1, "Java Web"),
    NEO_JAVA_WEB_TOMCAT7("neo-java-web-tomcat7", "neo-java-web", 2, "Java Web Tomcat 7"),
    NEO_JAVA_WEB_TOMCAT8("neo-java-web-tomcat8", "neo-java-web", 3, "Java Web Tomcat 8"),
    NEO_JAVAEE_6WP("neo-javaee6-wp", "neo-javaee6-wp", 2, "Java EE 6 Web Profile"),
    NEO_JAVAEE_7WP("neo-javaee7-wp", "neo-javaee7-wp", 1, "Java EE 7 Web Profile TomEE 7");

    private static final String UNSUPPORTED_RUNTIME_MESSAGE = "Runtime with id {0} and version {1} is not supported.";
    private static final String RUNTIME_WITH_UID_NOT_SUPPORTED = "Runtime with UID {0} is not supported.";
    public static final String NEO_JAVA_WEB_RUNTIME_ID = "neo-java-web";
    public static final String NEO_JAVAEE_6WP_RUNTIME_ID = "neo-javaee6-wp";
    public static final String NEO_JAVAEE_7WP_RUNTIME_ID = "neo-javaee7-wp";
    private final String runtimeUID;
    private final String runtimeId;
    private final int runtimeVersion;
    private final String fullName;

    private RuntimeType(String runtimeUID, String runtimeId, int runtimeVersion, String fullName) {
        this.runtimeUID = runtimeUID;
        this.runtimeId = runtimeId;
        this.runtimeVersion = runtimeVersion;
        this.fullName = fullName;
    }

    public String getRuntimeUID() {
        return this.runtimeUID;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public int getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public String getFullName() {
        return this.fullName;
    }

    public static RuntimeType getRuntimeType(String runtimeId, int runtimeVersion) {
        if (NEO_JAVA_WEB_RUNTIME_ID.equals(runtimeId)) {
            switch (runtimeVersion) {
                case 1: {
                    return NEO_JAVA_WEB;
                }
                case 2: {
                    return NEO_JAVA_WEB_TOMCAT7;
                }
                case 3: {
                    return NEO_JAVA_WEB_TOMCAT8;
                }
            }
        } else {
            if (NEO_JAVAEE_6WP_RUNTIME_ID.equals(runtimeId) && runtimeVersion == NEO_JAVAEE_6WP.getRuntimeVersion()) {
                return NEO_JAVAEE_6WP;
            }
            if (NEO_JAVAEE_7WP_RUNTIME_ID.equals(runtimeId) && runtimeVersion == NEO_JAVAEE_7WP.getRuntimeVersion()) {
                return NEO_JAVAEE_7WP;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(UNSUPPORTED_RUNTIME_MESSAGE, runtimeId, runtimeVersion));
    }

    public static RuntimeType getRuntimeType(String runtimeUID) {
        if (NEO_JAVA_WEB.getRuntimeUID().equals(runtimeUID)) {
            return NEO_JAVA_WEB;
        }
        if (NEO_JAVA_WEB_TOMCAT7.getRuntimeUID().equals(runtimeUID)) {
            return NEO_JAVA_WEB_TOMCAT7;
        }
        if (NEO_JAVA_WEB_TOMCAT8.getRuntimeUID().equals(runtimeUID)) {
            return NEO_JAVA_WEB_TOMCAT8;
        }
        if (NEO_JAVAEE_6WP.getRuntimeUID().equals(runtimeUID)) {
            return NEO_JAVAEE_6WP;
        }
        if (NEO_JAVAEE_7WP.getRuntimeUID().equals(runtimeUID)) {
            return NEO_JAVAEE_7WP;
        }
        throw new IllegalArgumentException(MessageFormat.format(RUNTIME_WITH_UID_NOT_SUPPORTED, runtimeUID));
    }

    public String toString() {
        return this.runtimeUID;
    }
}

