/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.sdk.status;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.sap.core.utils.sdk.status.RuntimeType;
import com.sap.core.utils.sdk.status.SDKStatus;
import com.sap.core.utils.sdk.status.SDKVersion;
import com.sap.core.utils.sdk.status.SDKVersionStatus;
import com.sap.core.utils.sdk.status.SdkRuntimeUndefinedException;
import com.sap.core.utils.sdk.status.Version;
import com.sap.core.utils.security.logon.LogonUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ServiceUnavailableException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class SDKVersionStatusUtils {
    private static final String MSG_SDK_RUNTIME_NOT_SUPPORTED = "SDK runtime is not supported.";
    private static final String MSG_LANDSCAPE_UNDEFINED = "Cannot determine SDK status. Landscape {0} not recognized.";
    private static final String MSG_REQUEST_RETURNED = "Request to {0} returned {1}";
    private static final String FAILED_TO_CLOSE_VERSION_STREAM = "Failed to close version stream";
    private static final String ERR_FAILED_TO_PARSE_ENDPOINT_JSON_RESPONSE_UNEXPECTED_DATA_FORMATTING_MESSAGE = "Failed to parse endpoint json response. Unexpected data formatting.";
    private static final String CLOUDSDK_JSON = "/cloudsdk.json";
    private static final String TOOLS_URL = "https://tools.{0}";
    private static final int HTTP_TIMEOUT = 3000;
    private static Gson gson = new Gson();
    private static JsonParser parser = new JsonParser();
    private static final Logger logger = Logger.getLogger(SDKVersionStatusUtils.class.getCanonicalName());

    public static SDKVersionStatus determineStatus(String version, String landscape, RuntimeType neoRuntime) throws ServiceUnavailableException, IOException, SdkRuntimeUndefinedException {
        List<SDKVersion> supportedSDKVersions = SDKVersionStatusUtils.getSupportedSDKVersions(landscape, neoRuntime);
        return SDKVersionStatusUtils.calculateStatusOfSDK(version, supportedSDKVersions);
    }

    public static List<SDKVersion> getSupportedSDKVersions(String landscape, RuntimeType neoRuntime) throws ServiceUnavailableException, IOException, SdkRuntimeUndefinedException {
        List<SDKVersion> supportedSDKs = new ArrayList<SDKVersion>();
        String toolsPageUrl = MessageFormat.format(TOOLS_URL, landscape);
        InputStreamReader reader = null;
        try {
            HttpResponse response = SDKVersionStatusUtils.performCall(toolsPageUrl);
            StatusLine statusLine = response.getStatusLine();
            logger.fine(MessageFormat.format(MSG_REQUEST_RETURNED, toolsPageUrl, statusLine));
            if (statusLine.getStatusCode() == 503) {
                throw new ServiceUnavailableException(String.valueOf(statusLine.toString()) + " " + landscape);
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                reader = new InputStreamReader(entity.getContent());
                supportedSDKs = SDKVersionStatusUtils.parseVersionsFromJsonByRuntime(neoRuntime.getRuntimeUID(), landscape, reader);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Throwable throwable) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    logger.fine(FAILED_TO_CLOSE_VERSION_STREAM);
                }
            }
            throw throwable;
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                logger.fine(FAILED_TO_CLOSE_VERSION_STREAM);
            }
        }
        return supportedSDKs;
    }

    public static SDKVersionStatus calculateStatusOfSDK(String sdkVersion, List<SDKVersion> supportedVersions) {
        SDKVersionStatus resultStatus = new SDKVersionStatus();
        if (supportedVersions == null || supportedVersions.size() == 0) {
            resultStatus.setStatus(SDKStatus.UNDEFINED);
            return resultStatus;
        }
        SDKVersionStatusUtils.sortVersionsASC(supportedVersions);
        Version userVersion = new Version(sdkVersion);
        Version newestVersion = new Version(SDKVersionStatusUtils.getLastElement(supportedVersions).getVersion());
        if (userVersion.compareTo(newestVersion) > 0) {
            resultStatus.setStatus(SDKStatus.LATEST);
            resultStatus.setSdk(SDKVersionStatusUtils.getLastElement(supportedVersions));
        } else {
            int i = supportedVersions.size() - 1;
            while (i >= 0) {
                SDKVersion sdk = supportedVersions.get(i);
                Version comparedVersion = new Version(sdk.getVersion());
                if (userVersion.compareVersionsWithoutHotfix(comparedVersion) == 0) {
                    if (userVersion.compareTo(comparedVersion) >= 0) {
                        if (userVersion.compareTo(newestVersion) < 0) {
                            resultStatus.setStatus(SDKStatus.UPDATE_AVAILABLE);
                            resultStatus.setSdk(SDKVersionStatusUtils.getLastElement(supportedVersions));
                            break;
                        }
                        resultStatus.setStatus(SDKStatus.LATEST);
                        resultStatus.setSdk(sdk);
                        break;
                    }
                    if (userVersion.isHotfixVersion() || comparedVersion.isHotfixVersion()) {
                        resultStatus.setStatus(SDKStatus.HOTFIX_AVAILABLE);
                        resultStatus.setSdk(sdk);
                        break;
                    }
                }
                --i;
            }
        }
        if (resultStatus.getSdk() == null) {
            resultStatus.setStatus(SDKStatus.NOT_SUPPORTED);
            resultStatus.setSdk(SDKVersionStatusUtils.getLastElement(supportedVersions));
        }
        return resultStatus;
    }

    private static void sortVersionsASC(List<SDKVersion> supportedVersions) {
        Collections.sort(supportedVersions, new Comparator<SDKVersion>(){

            @Override
            public int compare(SDKVersion v1, SDKVersion v2) {
                Version version1 = new Version(v1.getVersion());
                Version version2 = new Version(v2.getVersion());
                return version1.compareTo(version2);
            }
        });
    }

    private static SDKVersion getLastElement(List<SDKVersion> sdkVersions) {
        return sdkVersions.get(sdkVersions.size() - 1);
    }

    private static Type getSDKVersionListType() {
        return new TypeToken<List<SDKVersion>>(){}.getType();
    }

    static List<SDKVersion> parseVersionsFromJsonByRuntime(String neoRuntime, String landscape, Reader jsonContent) throws SdkRuntimeUndefinedException {
        ArrayList<SDKVersion> resultList = new ArrayList();
        try {
            JsonObject element = parser.parse(jsonContent).getAsJsonObject();
            if (!element.has(neoRuntime)) {
                throw new SdkRuntimeUndefinedException(MessageFormat.format(MSG_SDK_RUNTIME_NOT_SUPPORTED, neoRuntime));
            }
            resultList = (List)gson.fromJson(element.get(neoRuntime).getAsJsonArray().toString(), SDKVersionStatusUtils.getSDKVersionListType());
        }
        catch (JsonSyntaxException ex) {
            logger.log(Level.FINE, ERR_FAILED_TO_PARSE_ENDPOINT_JSON_RESPONSE_UNEXPECTED_DATA_FORMATTING_MESSAGE, ex);
            throw new SdkRuntimeUndefinedException(MessageFormat.format(MSG_LANDSCAPE_UNDEFINED, landscape), ex);
        }
        return resultList;
    }

    private static HttpResponse performCall(String toolsPageUrl) throws IOException {
        HttpClient httpclient = LogonUtils.createHttpClientWithoutAuth(toolsPageUrl);
        HttpGet httpGet = new HttpGet(String.valueOf(toolsPageUrl) + CLOUDSDK_JSON);
        BasicHttpParams httpParameters = new BasicHttpParams();
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)3000);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)3000);
        httpGet.setParams((HttpParams)httpParameters);
        return httpclient.execute((HttpUriRequest)httpGet);
    }
}

