/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.sdk.status;

import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private Integer major;
    private Integer minor;
    private Integer micro;
    private Integer fix;
    private static final String SEPARATOR = ".";
    public static final Version emptyVersion = new Version(0, 0, 0);

    public Version(Integer major, Integer minor, Integer micro) {
        this(major, minor, micro, 0);
    }

    public Version(Integer major, Integer minor, Integer micro, Integer fix) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.fix = fix;
        this.validate();
    }

    public Version(String version) {
        String[] splitVersion = Version.splitVersion(version);
        this.major = Version.parseInt(splitVersion[0], version);
        this.minor = Version.parseInt(splitVersion[1], version);
        this.micro = Version.parseInt(splitVersion[2], version);
        this.fix = splitVersion.length > 3 ? Integer.valueOf(Version.parseInt(splitVersion[3], version)) : Integer.valueOf(0);
        this.validate();
    }

    private static int parseInt(String value, String version) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid version \"" + version + "\": non-numeric \"" + value + "\"");
            iae.initCause(e);
            throw iae;
        }
    }

    public static Version parseVersion(String version) {
        if (version == null) {
            return emptyVersion;
        }
        String trimmedVersion = version.trim();
        if (trimmedVersion.length() == 0) {
            return emptyVersion;
        }
        return new Version(trimmedVersion);
    }

    private void validate() {
        this.validate0(this.major);
        this.validate0(this.minor);
        this.validate0(this.micro);
        this.validate0(this.fix);
    }

    private void validate0(Integer component) {
        if (component < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString() + "\": negative number \"" + component + "\"");
        }
    }

    public static String[] splitVersion(String version) throws IllegalArgumentException {
        return version.split(Pattern.quote(SEPARATOR));
    }

    public boolean isHotfixVersion() {
        return this.getFix() != null && this.getFix() != 0;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getMicro() {
        return this.micro;
    }

    public Integer getFix() {
        return this.fix;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.major);
        result.append(SEPARATOR);
        result.append(this.minor);
        result.append(SEPARATOR);
        result.append(this.micro);
        if (this.fix != 0) {
            result.append(SEPARATOR);
            result.append(this.fix);
        }
        return result.toString();
    }

    public int compareVersionsWithoutHotfix(Version other) {
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        return result;
    }

    @Override
    public int compareTo(Version other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        return this.fix - other.fix;
    }

    public int hashCode() {
        int h = 527;
        h = 31 * h + this.major;
        h = 31 * h + this.minor;
        h = 31 * h + this.micro;
        h = 31 * h + this.fix;
        return h;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        return this.major.equals(other.major) && this.minor.equals(other.minor) && this.micro.equals(other.micro) && this.fix.equals(other.fix);
    }
}

