/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.sdk.utils;

import com.sap.core.utils.sdk.utils.HttpRequestExecutor;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.util.EntityUtils;

public class EulaCookieBuilder {
    private static final String QUOTE = "\"";
    private static final String SEMI_COL = ";";
    private static final String SLASH = "/";
    private static final String TOOLS_PREFIX = "tools.";
    private static final String EQUAL_SIGN = "=";
    private static final String COOKIE = "document.cookie =";
    private static final String DOWNLOAD_URL = "https://tools.{0}/";

    public static Cookie createCookie(String host) throws IOException {
        BasicClientCookie cookie = null;
        Date date = EulaCookieBuilder.getExpiryDate();
        String[] cookieName = EulaCookieBuilder.getCookie(host);
        if (cookieName != null && cookieName.length == 2) {
            cookie = new BasicClientCookie(cookieName[0], cookieName[1]);
            cookie.setPath(SLASH);
            cookie.setDomain(TOOLS_PREFIX + host);
            cookie.setExpiryDate(date);
        }
        return cookie;
    }

    private static Date getExpiryDate() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 90);
        date = calendar.getTime();
        return date;
    }

    private static String[] getCookie(String host) throws IOException {
        String cookieNameValue = null;
        String url = MessageFormat.format(DOWNLOAD_URL, host);
        HttpResponse response = new HttpRequestExecutor(url).sendHttpGetRequestNoAuth();
        HttpEntity destinationEntity = response.getEntity();
        String htmlContent = EntityUtils.toString((HttpEntity)destinationEntity);
        if (htmlContent.contains(COOKIE)) {
            String line = htmlContent.substring(htmlContent.indexOf(COOKIE));
            cookieNameValue = line.substring(line.indexOf(QUOTE) + 1, line.indexOf(SEMI_COL));
        }
        return cookieNameValue != null ? cookieNameValue.split(EQUAL_SIGN) : null;
    }
}

