/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.sdk.utils;

import com.sap.core.utils.sdk.utils.EulaCookieBuilder;
import com.sap.core.utils.sdk.utils.HttpRequestExecutor;
import com.sap.core.utils.sdk.utils.SdkFileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.cookie.Cookie;
import org.apache.http.util.EntityUtils;

public class SdkCallUtils {
    private static final String NOT_ENOUGH_DISK_SPACE_IS_AVAILABLE = "Not enough disk space is available.";
    private static final String COULD_NOT_DOWNLOAD_SDK = "Could not download SDK file. Reason: {0}";
    private static final String COULD_NOT_RETRIEVE_SDK_LICENSE_HTTP_CALL_STATUS_LINE = "Could not retrieve SDK license. Reason: {0}";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String LICENSE_URL = "https://tools.{0}/developer-license.txt";
    private static final Logger logger = Logger.getLogger(SdkCallUtils.class.getCanonicalName());

    public static String getLicense(String host) throws IOException {
        String license;
        block6: {
            license = null;
            String licensePage = MessageFormat.format(LICENSE_URL, host);
            HttpResponse response = new HttpRequestExecutor(licensePage).sendHttpGetRequestNoAuth();
            StatusLine httpStatusLine = response.getStatusLine();
            logger.fine(MessageFormat.format("HTTP response status line for license download request is  {0}", httpStatusLine.toString()));
            HttpEntity entity = response.getEntity();
            try {
                if (httpStatusLine.getStatusCode() == 200) {
                    if (entity != null) {
                        license = EntityUtils.toString((HttpEntity)entity);
                    }
                    break block6;
                }
                if (entity != null) {
                    logger.fine(MessageFormat.format("Response entitiy is {0}", EntityUtils.toString((HttpEntity)entity)));
                }
                throw new IOException(MessageFormat.format(COULD_NOT_RETRIEVE_SDK_LICENSE_HTTP_CALL_STATUS_LINE, httpStatusLine.toString()));
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
        return license;
    }

    public static boolean downloadSdkZipFile(String downloadLink, String host, String destionationFile) throws IOException {
        boolean result;
        block9: {
            result = false;
            Cookie cookie = EulaCookieBuilder.createCookie(host);
            HttpResponse response = new HttpRequestExecutor(downloadLink).sendHttpGetRequestNoAuth(cookie);
            HttpEntity destinationEntity = response.getEntity();
            String filesize = response.getLastHeader(HEADER_CONTENT_LENGTH).getValue();
            try {
                try {
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine.getStatusCode() == 200) {
                        long sdkSizeValue = Long.parseLong(filesize);
                        result = SdkFileUtils.checkIfEnoughDiskSpaceIsAvailable(4L * sdkSizeValue);
                        if (result) {
                            SdkCallUtils.saveFileFromHTTPResponse(destinationEntity.getContent(), destionationFile);
                            File zip = new File(destionationFile);
                            if (zip.isFile()) {
                                zip.deleteOnExit();
                            }
                            break block9;
                        }
                        long usablePatitionSpace = new File(".").getUsableSpace();
                        long requiredDiskSpace = 4L * sdkSizeValue;
                        logger.fine(MessageFormat.format("Usable Space : {0} MB", usablePatitionSpace / 0x100000L));
                        logger.fine(MessageFormat.format("Required Space : {0} MB", requiredDiskSpace / 0x100000L));
                        logger.fine(NOT_ENOUGH_DISK_SPACE_IS_AVAILABLE);
                        throw new IOException(NOT_ENOUGH_DISK_SPACE_IS_AVAILABLE);
                    }
                    if (destinationEntity != null) {
                        logger.fine(MessageFormat.format("Response entitiy is {0}", EntityUtils.toString((HttpEntity)destinationEntity)));
                    }
                    throw new IOException(MessageFormat.format(COULD_NOT_DOWNLOAD_SDK, statusLine.toString()));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.fine(MessageFormat.format("Could not parse HTTP header {0} with value {1} to long.", HEADER_CONTENT_LENGTH, filesize));
                    EntityUtils.consumeQuietly((HttpEntity)destinationEntity);
                }
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)destinationEntity);
            }
        }
        return result;
    }

    private static void saveFileFromHTTPResponse(InputStream inputStream, String destinationFilePath) throws IOException {
        File destinationFile = new File(destinationFilePath).getAbsoluteFile();
        destinationFile.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(destinationFile);
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }
}

