/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.sdk.utils;

import com.sap.core.utils.sdk.utils.EulaCookieBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;

public class SdkFileUtils {
    private static final String TEMP = "temp";
    private static final String TESTSDKSTATUS = "testsdkstatus";
    private static final String MESSAGE_FILE_IS_USED = "Another program is currently using file {0}. Please close the program and try again.";
    private static Logger logger = Logger.getLogger(EulaCookieBuilder.class.getCanonicalName());

    public static boolean checkIfFileIsLocked(File file) {
        boolean isFileLocked = false;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, true);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            isFileLocked = true;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An error occurred while trying to close file streams.", e);
        }
        return isFileLocked;
    }

    public static boolean checkIfDirectoryIsUsed(File dir) {
        boolean isLocked = false;
        Collection listFiles = FileUtils.listFiles((File)dir, null, (boolean)true);
        for (File f : listFiles) {
            if (!SdkFileUtils.checkIfFileIsLocked(f)) continue;
            isLocked = true;
            System.out.println(MessageFormat.format(MESSAGE_FILE_IS_USED, f.getAbsolutePath()));
        }
        return isLocked;
    }

    public static void extractZipFile(String fileName, String destinationDirectory) throws IOException {
        if (!destinationDirectory.endsWith(File.separator)) {
            destinationDirectory = String.valueOf(destinationDirectory) + File.separator;
        }
        byte[] buf = new byte[1024];
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(fileName));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                File temp = new File(String.valueOf(destinationDirectory) + entryName);
                if (zipEntry.isDirectory()) {
                    temp.mkdirs();
                } else {
                    FileOutputStream fileOutputStream = null;
                    try {
                        int n;
                        fileOutputStream = new FileOutputStream(temp);
                        while ((n = zipInputStream.read(buf, 0, 1024)) > -1) {
                            fileOutputStream.write(buf, 0, n);
                        }
                    }
                    finally {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        zipInputStream.closeEntry();
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    public static String getCurrentPath() {
        File file = new File(".").getAbsoluteFile();
        return file.getParent();
    }

    public static boolean checkIfEnoughDiskSpaceIsAvailable(Long fileSize) {
        return new File(SdkFileUtils.getTempPath()).getUsableSpace() >= fileSize;
    }

    public static String getTempPath() {
        String path = null;
        try {
            File tempFile = File.createTempFile(TESTSDKSTATUS, TEMP);
            path = tempFile.getAbsoluteFile().getParent();
            tempFile.deleteOnExit();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "An error occured while trying to create temp file in tmp directory", ex);
        }
        return path;
    }
}

