/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.security.logon;

import com.sap.core.utils.security.logon.CsrfHttpClient;
import com.sap.core.utils.security.logon.CustomProxySelector;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;

public class BasicAuthHttpClientProvider {
    public static final String USER = "User";
    public static final String PASSWORD = "Password";
    public static final String URL = "URL";

    public static HttpClient createHttpClient(Properties properties) {
        try {
            return BasicAuthHttpClientProvider.createClientWithBasicAuth(properties.getProperty(USER), properties.getProperty(PASSWORD), properties.getProperty(URL));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CsrfHttpClient createCsrfHttpClient(String url, String username, String password, String csrfGetTokenUrl) throws IOException {
        HttpClient httpClient = BasicAuthHttpClientProvider.createClientWithBasicAuth(username, password, url);
        return new CsrfHttpClient(httpClient, csrfGetTokenUrl);
    }

    public static CsrfHttpClient createCsrfHttpClient(HttpClient httpClient, String csrfGetTokenUrl) throws IOException {
        return new CsrfHttpClient(httpClient, csrfGetTokenUrl);
    }

    private static HttpClient createClientWithBasicAuth(String username, String password, String url) throws IOException {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());
        try {
            URI uri = new URI(url);
            if (uri.getScheme() == null) {
                throw new IllegalArgumentException("Cannot create http client because the supplied host URL [" + url + "] doesn't contain scheme");
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot create http client because the supplied host URL [" + url + "] is not valid", e);
        }
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(defaultHttpClient.getConnectionManager().getSchemeRegistry(), (ProxySelector)new CustomProxySelector());
        defaultHttpClient.setRoutePlanner((HttpRoutePlanner)routePlanner);
        BasicAuthHttpClientProvider.setAuthCredentials(defaultHttpClient, username, password);
        BasicAuthHttpClientProvider.setProxyCredentials(defaultHttpClient);
        HttpParams params = defaultHttpClient.getParams();
        params.setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        return defaultHttpClient;
    }

    public static void setAuthCredentials(DefaultHttpClient httpClient, String username, String password) {
        if (httpClient != null && username != null && password != null) {
            Credentials credentials = BasicAuthHttpClientProvider.getCredentials(username, password);
            httpClient.getParams().setParameter("http.auth.credential-charset", (Object)"UTF-8");
            httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, credentials);
        }
    }

    private static void setProxyCredentials(DefaultHttpClient httpClient) {
        String proxyHttpsHost = System.getProperty("https.proxyHost", System.getProperty("http.proxyHost"));
        String proxyHttpsPort = System.getProperty("https.proxyPort", System.getProperty("http.proxyPort"));
        String proxyHttpsUser = System.getProperty("https.proxyUser", System.getProperty("http.proxyUser"));
        String proxyHttpsPassword = System.getProperty("https.proxyPassword", System.getProperty("http.proxyPassword"));
        if (proxyHttpsHost != null && proxyHttpsPort != null && proxyHttpsUser != null && proxyHttpsPassword != null) {
            int port = Integer.parseInt(proxyHttpsPort);
            proxyHttpsHost = BasicAuthHttpClientProvider.convertHostNameToIpAddress(proxyHttpsHost);
            AuthScope authenticationScope = new AuthScope(proxyHttpsHost, port);
            Credentials proxyCredentials = BasicAuthHttpClientProvider.getCredentials(proxyHttpsUser, proxyHttpsPassword);
            httpClient.getCredentialsProvider().setCredentials(authenticationScope, proxyCredentials);
            HttpHost proxy = new HttpHost(proxyHttpsHost, port);
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
    }

    private static String convertHostNameToIpAddress(String proxyHttpsHost) {
        String ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(proxyHttpsHost).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {}
        if (ipAddress != null) {
            proxyHttpsHost = ipAddress;
        }
        return proxyHttpsHost;
    }

    private static Credentials getCredentials(String username, String password) {
        UsernamePasswordCredentials credentials = null;
        if (username != null && password != null) {
            credentials = new UsernamePasswordCredentials(username, password);
        }
        return credentials;
    }
}

