/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.security.logon;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class CustomProxySelector
extends ProxySelector {
    private static final String ERROR_PROXY_PORT_CANNOT_BE_DETERMINED = "The proxy port could not be determined, ensure that the proxy port property is a number, current value is ''{0}''.";
    private static final String PROXY_PORT_SUFIX = ".proxyPort";
    private static final String PROXY_HOST_SUFIX = ".proxyHost";
    private static final String NON_PROXY_HOSTS_SUFIX = ".nonProxyHosts";

    @Override
    public List<Proxy> select(URI uri) {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        this.createHttpProxiesFromSystemProperties(proxies, uri.getHost());
        if (proxies.isEmpty()) {
            this.createHttpProxiesFromEnvironmentVariables(proxies, uri.getHost());
            if (proxies.isEmpty()) {
                proxies.add(Proxy.NO_PROXY);
            }
        }
        return proxies;
    }

    private void createHttpProxiesFromSystemProperties(List<Proxy> proxies, String host) {
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (this.isNonProxyHost(host, nonProxyHosts)) {
            proxies.add(Proxy.NO_PROXY);
        } else {
            this.createProxyFromSystemProperties(proxies, "http", 80);
            this.createProxyFromSystemProperties(proxies, "https", 443);
        }
    }

    private void createProxyFromSystemProperties(List<Proxy> proxies, String protocol, int defaultPort) {
        Proxy proxy;
        String proxyHost = System.getProperty(String.valueOf(protocol) + PROXY_HOST_SUFIX);
        if (proxyHost != null && (proxy = this.createProxy(proxyHost.trim(), System.getProperty(String.valueOf(protocol) + PROXY_PORT_SUFIX, "" + defaultPort))) != null) {
            proxies.add(proxy);
        }
    }

    private void createHttpProxiesFromEnvironmentVariables(List<Proxy> proxies, String host) {
        String nonProxyHosts = System.getenv("http.nonProxyHosts");
        if (this.isNonProxyHost(host, nonProxyHosts)) {
            proxies.add(Proxy.NO_PROXY);
        } else {
            this.createProxyFromEnvironmentVariables(proxies, "http", 80);
            this.createProxyFromEnvironmentVariables(proxies, "https", 443);
        }
    }

    private void createProxyFromEnvironmentVariables(List<Proxy> proxies, String protocol, int defaultPort) {
        String proxyHost = System.getenv(String.valueOf(protocol) + PROXY_HOST_SUFIX);
        if (proxyHost != null) {
            Proxy proxy;
            String proxyPort = System.getenv(String.valueOf(protocol) + PROXY_PORT_SUFIX);
            if (proxyPort == null) {
                proxyPort = "" + defaultPort;
            }
            if ((proxy = this.createProxy(proxyHost.trim(), proxyPort)) != null) {
                proxies.add(proxy);
            }
        }
    }

    private boolean isNonProxyHost(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        int length = nonProxyHosts.length();
        StringBuilder buf = new StringBuilder(length);
        int i = 0;
        while (i < nonProxyHosts.length()) {
            char ch = nonProxyHosts.charAt(i);
            switch (ch) {
                case '\"': {
                    break;
                }
                case '.': {
                    buf.append("\\.");
                    break;
                }
                case '*': {
                    buf.append(".*");
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            ++i;
        }
        String nonProxyHostsReg = buf.toString();
        return host.matches(nonProxyHostsReg);
    }

    private Proxy createProxy(String host, String port) {
        Proxy proxy = null;
        try {
            InetSocketAddress resolvedAddress = this.getResolvedProxyAddress(host, port);
            if (resolvedAddress != null) {
                proxy = new Proxy(Proxy.Type.HTTP, resolvedAddress);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(MessageFormat.format(ERROR_PROXY_PORT_CANNOT_BE_DETERMINED, port));
        }
        return proxy;
    }

    private InetSocketAddress getResolvedProxyAddress(String host, String port) throws NumberFormatException {
        InetSocketAddress resolvedAddress = null;
        if (host != null && host.trim().length() > 0) {
            resolvedAddress = new InetSocketAddress(host, Integer.parseInt(port));
        }
        return resolvedAddress == null || resolvedAddress.isUnresolved() ? null : resolvedAddress;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }
}

