/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.security.logon;

import com.sap.core.utils.infrastructure.validation.i18n.Messages;
import com.sap.core.utils.security.logon.BasicAuthHttpClientProvider;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;

public class LogonUtils {
    public static final String RESPONSE_CODE_USER_INACTIVE = "USER_INACTIVE";
    public static final String RESPONSE_CODE_PWD_WRONG = "PWD_WRONG";
    public static final String RESPONSE_CODE_PWD_LOCKED = "PWD_LOCKED";
    public static final String RESPONSE_CODE_PWD_DISABLED = "PWD_DISABLED";
    public static final String RESPONSE_CODE_PASSWORD_CHANGE_REQUIRED = "PASSWORD_CHANGE_REQUIRED";
    public static final String RESPONSE_CODE_PASSWORD_RESET_REQUIRED = "PASSWORD_RESET_REQUIRED";
    public static final String RESPONSE_HEADER_X_MESSAGE_CODE = "X-message-code";

    private static ResponseCode getResponseCode(String code) {
        ResponseCode responseCode = null;
        responseCode = code != null ? (code.equals(RESPONSE_CODE_USER_INACTIVE) ? ResponseCode.USER_INACTIVE : (code.equals(RESPONSE_CODE_PWD_WRONG) ? ResponseCode.PWD_WRONG : (code.equals(RESPONSE_CODE_PWD_LOCKED) ? ResponseCode.PWD_LOCKED : (code.equals(RESPONSE_CODE_PWD_DISABLED) ? ResponseCode.PWD_DISABLED : (code.equals(RESPONSE_CODE_PASSWORD_CHANGE_REQUIRED) ? ResponseCode.PASSWORD_CHANGE_REQUIRED : (code.equals(RESPONSE_CODE_PASSWORD_RESET_REQUIRED) ? ResponseCode.PASSWORD_RESET_REQUIRED : ResponseCode.GENERAL)))))) : ResponseCode.NONE;
        return responseCode;
    }

    public static HttpClient createHttpClient(String url, String username, String password) {
        Properties props = new Properties();
        props.put("URL", url);
        props.put("User", username);
        props.put("Password", password);
        return BasicAuthHttpClientProvider.createHttpClient(props);
    }

    public static HttpClient createHttpClientWithoutAuth(String url) {
        Properties props = new Properties();
        props.put("URL", url);
        return BasicAuthHttpClientProvider.createHttpClient(props);
    }

    public static String getAuthenticationFailureErrorMessage(HttpResponse response) {
        String message = null;
        Header header = response.getFirstHeader(RESPONSE_HEADER_X_MESSAGE_CODE);
        if (header != null) {
            switch (LogonUtils.getResponseCode(header.getValue())) {
                case USER_INACTIVE: {
                    message = Messages.LogonUtils_INACTIVE_ACCOUNT_ACTIVATE_IT_VIA_YOUR_ACCOUNT_CREATION_CONFIRMATION_EMAIL;
                    break;
                }
                case PWD_WRONG: {
                    message = Messages.LogonUtils_WRONG_USER_NAME_OR_PASSWORD;
                    break;
                }
                case PWD_LOCKED: {
                    message = Messages.LogonUtils_YOUR_ACCOUNT_IS_TEMPORARILY_LOCKED_IT_WILL_BE_AUTOMATICALLY_UNLOCKED_IN_60_MINUTES;
                    break;
                }
                case PWD_DISABLED: {
                    message = Messages.LogonUtils_PASSWORD_AUTHENTICATION_IS_DISABLED_FOR_YOUR_ACCOUNT_LOG_IN_WITH_A_CERTIFICATE;
                    break;
                }
                case PASSWORD_CHANGE_REQUIRED: {
                    message = Messages.LogonUtils_PASSWORD_CHANGE_REQUIRED_CHANGE_YOUR_PASSWORD_FROM_HTTPS_ACCOUNTS_SAP_COM;
                    break;
                }
                case PASSWORD_RESET_REQUIRED: {
                    message = Messages.LogonUtils_PASSWORD_RESET_REQUIRED_RESET_YOUR_PASSWORD_FROM_HTTPS_ACCOUNTS_SAP_COM;
                    break;
                }
                case GENERAL: {
                    message = Messages.LogonUtils_LOGIN_FAILED_CONTACT_YOUR_ADMINISTRATOR;
                }
            }
        }
        return message;
    }

    private static enum ResponseCode {
        USER_INACTIVE,
        PWD_WRONG,
        PWD_LOCKED,
        PWD_DISABLED,
        PASSWORD_CHANGE_REQUIRED,
        PASSWORD_RESET_REQUIRED,
        GENERAL,
        NONE;

    }
}

