/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging.kotyo.lifecycle;

import com.sap.core.js.logging.LoggingFieldProvider;
import com.sap.core.js.logging.LoggingFieldProvidersService;
import com.sap.core.js.logging.LoggingLifecycleHandler;
import com.sap.core.js.logging.config.LoggingConfigurator;
import com.sap.core.services.accessor.lifecycle.InternalComponentLifecycle;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4J;

public class LoggingLifecycle
implements InternalComponentLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(LoggingLifecycle.class);
    private static final String LOGGING_CFG_FILE = System.getProperty("server.config.home") + File.separator + "config_master" + File.separator + "com.sap.js.logging" + File.separator + "logging.cfg";
    private LoggingLifecycleHandler loggingLifecycleHandler;

    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug("Staring logging component from LoggingLifecycle class.");
        }
        SysOutOverSLF4J.sendSystemOutAndErrToSLF4J();
        this.loggingLifecycleHandler = new LoggingLifecycleHandler();
        this.loggingLifecycleHandler.initialize();
        this.readConfiguration();
        this.initializeLoggingProviders();
    }

    public void stop() {
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping logging component from LoggingLifecycle class.");
        }
        if (this.loggingLifecycleHandler != null) {
            this.loggingLifecycleHandler.destroy();
        } else {
            logger.error("Internal loggingLifecycleHandler object is not available. It must have been initialized on server start.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfiguration() {
        File loggingConfigFile = new File(LOGGING_CFG_FILE);
        Properties loggingConfig = new Properties();
        FileReader logConfigurationReader = null;
        try {
            logConfigurationReader = new FileReader(loggingConfigFile);
            loggingConfig.load(logConfigurationReader);
            LoggingConfigurator loggingConfigurator = new LoggingConfigurator();
            loggingConfigurator.updateProperties(loggingConfig);
        }
        catch (IOException e) {
            logger.error("Cannot read properties from " + loggingConfigFile.getAbsolutePath(), (Throwable)e);
        }
        finally {
            this.closeNoFail(logConfigurationReader);
        }
        if (logger.isDebugEnabled()) {
            this.dumpLoggingConfiguration(loggingConfigFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLoggingConfiguration(File loggingConfigFile) {
        BufferedReader bufferedReader;
        FileReader logConfigurationReader;
        block6: {
            logConfigurationReader = null;
            bufferedReader = null;
            if (loggingConfigFile.exists()) break block6;
            logger.debug("The log configuration file does not exist: " + loggingConfigFile.getAbsolutePath());
            this.closeNoFail(bufferedReader);
            this.closeNoFail(logConfigurationReader);
            return;
        }
        try {
            logConfigurationReader = new FileReader(loggingConfigFile);
            bufferedReader = new BufferedReader(logConfigurationReader);
            logger.debug("Dumping the logger configuration file:");
            String line = bufferedReader.readLine();
            while (null != line) {
                logger.debug("> {}", (Object)line);
                line = bufferedReader.readLine();
            }
            logger.debug("--- end---");
            this.closeNoFail(bufferedReader);
            this.closeNoFail(logConfigurationReader);
        }
        catch (IOException e) {
            try {
                logger.error("Failed to dump the logger configuration file: ", (Throwable)e);
                this.closeNoFail(bufferedReader);
                this.closeNoFail(logConfigurationReader);
            }
            catch (Throwable throwable) {
                this.closeNoFail(bufferedReader);
                this.closeNoFail(logConfigurationReader);
                throw throwable;
            }
        }
    }

    private void closeNoFail(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initializeLoggingProviders() {
        HashMap<String, LoggingFieldProvider> providers = new HashMap<String, LoggingFieldProvider>();
        ServiceLoader<LoggingFieldProvider> serviceLoader = ServiceLoader.load(LoggingFieldProvider.class, LoggingLifecycle.class.getClassLoader());
        Iterator<LoggingFieldProvider> iterator = serviceLoader.iterator();
        try {
            while (iterator.hasNext()) {
                LoggingFieldProvider fieldProvider = iterator.next();
                providers.put(fieldProvider.getFieldNames()[0], fieldProvider);
            }
        }
        catch (ServiceConfigurationError e) {
            logger.error("Failed looking up logging field providers: ", (Throwable)e);
        }
        if (!providers.isEmpty()) {
            LoggingFieldProvidersService.addProviders(providers);
        }
    }
}

