/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.impl.bridge.tenant;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.core.services.accessor.lifecycle.InternalComponentLifecycle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TenantObjectFactoryInitializer
implements InternalComponentLifecycle {
    static String UNABLE_TO_INITIALIZE = "Unable to initialize tenant object factory";
    private static Logger logger = Logger.getLogger(TenantObjectFactoryInitializer.class.getName());

    public void start() {
        try {
            ClassLoader implClassLoader = ClassloadingBridge.getImplClassLoader();
            Class<?> tenantServiceImplClass = implClassLoader.loadClass("com.sap.core.tenant.service.impl.TenantServiceImpl");
            Class<?> tenantServiceClass = implClassLoader.loadClass("com.sap.core.tenant.api.TenantService");
            Class<?> tenantContextClass = implClassLoader.loadClass("com.sap.cloud.account.impl.TenantContextImpl");
            ClassloadingBridge.invokeMethod(tenantContextClass, null, (String)"setTenantService", (Class[])new Class[]{tenantServiceClass}, (Object[])new Object[]{tenantServiceImplClass.newInstance()});
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, UNABLE_TO_INITIALIZE, e);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, UNABLE_TO_INITIALIZE, e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, UNABLE_TO_INITIALIZE, e);
        }
        catch (IllegalStateException e) {
            logger.log(Level.SEVERE, UNABLE_TO_INITIALIZE, e);
        }
    }

    public void stop() {
    }
}

