/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotee.jta.cleaner;

import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.openejb.OpenEJB;

public final class LeakedTransactionsReportValve
extends ValveBase {
    private static final Logger logger = Logger.getLogger(LeakedTransactionsReportValve.class.getName());
    private static final boolean WITH_ASYNC_SUPPORT = true;
    static final String PROPERTY_BASE = LeakedTransactionsReportValve.class.getName() + ".onStatus:";
    static final String ACTION_DO_NOTHING = "do_nothing";
    static final String ACTION_REPORT = "report";
    static final String ACTION_SUSPEND = "suspend";
    static final String ACTION_COMMIT = "commit";
    static final String ACTION_ROLLBACK = "rollback";
    private boolean isEnabled;
    private final RecoveryAction[] recoveryActions = new RecoveryActions[10];

    public LeakedTransactionsReportValve() {
        super(true);
        this.initRecoveryActionsFromConfig();
        this.enableOrDisableTransactionLeakDetection();
    }

    private void initRecoveryActionsFromConfig() {
        for (int i = 0; i < this.recoveryActions.length; ++i) {
            this.recoveryActions[i] = RecoveryActions.DoNothing;
        }
        this.recoveryActions[0] = RecoveryActions.Report;
        this.recoveryActions[1] = RecoveryActions.Report;
        Properties properties = System.getProperties();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(PROPERTY_BASE)) continue;
            String statusString = key.substring(PROPERTY_BASE.length());
            try {
                RecoveryAction recoveryAction;
                int status = Integer.valueOf(statusString);
                if (status > 9 || status < 0) {
                    logger.log(Level.SEVERE, "Skipping configuration for invalid status: " + status);
                    continue;
                }
                String actionString = properties.getProperty(key, ACTION_DO_NOTHING);
                this.recoveryActions[status] = recoveryAction = this.getRecoveryActionFromConfig(actionString);
                if (!logger.isLoggable(Level.CONFIG)) continue;
                logger.log(Level.CONFIG, "Using recovery action " + recoveryAction + " for status " + status);
            }
            catch (RuntimeException ex) {
                logger.log(Level.SEVERE, "Invalid property: " + key);
            }
        }
    }

    private void enableOrDisableTransactionLeakDetection() {
        for (RecoveryAction recoveryAction : this.recoveryActions) {
            if (recoveryAction == RecoveryActions.DoNothing) continue;
            this.isEnabled = true;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            if (this.isEnabled) {
                this.checkForLeakedTransactions();
            }
        }
    }

    private void checkForLeakedTransactions() {
        try {
            TransactionManager transactionManager = OpenEJB.getTransactionManager();
            Transaction transaction = transactionManager.getTransaction();
            if (null != transaction) {
                int transactionStatus = transaction.getStatus();
                RecoveryAction recoveryAction = this.recoveryActions[transactionStatus];
                recoveryAction.onLeakedTransaction(transactionManager);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unexpected exception while checking for leaked transactions.", ex);
        }
    }

    private RecoveryAction getRecoveryActionFromConfig(String config) {
        switch (config.toLowerCase(Locale.ENGLISH)) {
            case "commit": {
                return RecoveryActions.Commit;
            }
            case "rollback": {
                return RecoveryActions.RollBack;
            }
            case "suspend": {
                return RecoveryActions.Suspend;
            }
            case "report": {
                return RecoveryActions.Report;
            }
            case "do_nothing": {
                return RecoveryActions.DoNothing;
            }
        }
        logger.log(Level.SEVERE, "Unknown action '" + config + "' Using REPORT");
        return RecoveryActions.Report;
    }

    private static enum RecoveryActions implements RecoveryAction
    {
        DoNothing{

            @Override
            public void onLeakedTransaction(TransactionManager transactionManager) {
            }
        }
        ,
        Report{

            @Override
            public void onLeakedTransaction(TransactionManager transactionManager) {
                try {
                    logger.log(Level.SEVERE, "Detected leaked transaction: " + transactionManager.getTransaction() + " with status " + transactionManager.getStatus());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to report the transaction status: ", e);
                }
            }
        }
        ,
        Commit{

            @Override
            public void onLeakedTransaction(TransactionManager transactionManager) {
                try {
                    logger.log(Level.SEVERE, "Committing leaked transaction: " + transactionManager.getTransaction() + " with status " + transactionManager.getStatus());
                    transactionManager.commit();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to commit the transaction: ", e);
                }
            }
        }
        ,
        RollBack{

            @Override
            public void onLeakedTransaction(TransactionManager transactionManager) {
                try {
                    logger.log(Level.SEVERE, "Rolling back leaked transaction: " + transactionManager.getTransaction() + " with status " + transactionManager.getStatus());
                    transactionManager.rollback();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to roll back the transaction: ", e);
                }
            }
        }
        ,
        Suspend{

            @Override
            public void onLeakedTransaction(TransactionManager transactionManager) {
                try {
                    logger.log(Level.SEVERE, "Suspending leaked transaction: " + transactionManager.getTransaction() + " with status " + transactionManager.getStatus());
                    transactionManager.suspend();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to suspend the transaction: ", e);
                }
            }
        };

    }

    private static interface RecoveryAction {
        public void onLeakedTransaction(TransactionManager var1);
    }
}

