/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.ServerInfo;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.config.QuickJarsTxtParser;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.tomee.catalina.TomcatLoader;
import org.apache.tomee.loader.TomcatHelper;

public class ServerListener
implements LifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(ServerListener.class.getName());
    private static final AtomicBoolean listenerInstalled = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType()) && StandardServer.class.isInstance(event.getSource())) {
            this.installServerInfo();
        }
        AtomicBoolean atomicBoolean = listenerInstalled;
        synchronized (atomicBoolean) {
            if (listenerInstalled.get() || !"after_init".equals(event.getType())) {
                return;
            }
            if (!(event.getSource() instanceof StandardServer)) {
                return;
            }
            try {
                TomcatLoader loader;
                Properties properties;
                block24: {
                    StandardServer server = (StandardServer)event.getSource();
                    TomcatHelper.setServer((StandardServer)server);
                    properties = new Properties();
                    System.getProperties().setProperty("openejb.embedder.source", this.getClass().getSimpleName());
                    properties.setProperty("openejb.embedder.source", this.getClass().getSimpleName());
                    if (SystemInstance.isInitialized()) {
                        return;
                    }
                    properties.setProperty("openejb.loader", "tomcat-system");
                    String catalinaHome = System.getProperty("catalina.home");
                    properties.setProperty("openejb.home", catalinaHome);
                    System.setProperty("openejb.home", catalinaHome);
                    String catalinaBase = System.getProperty("catalina.base");
                    properties.setProperty("openejb.base", catalinaBase);
                    System.setProperty("openejb.base", catalinaBase);
                    ClassLoader classLoader = ServerListener.class.getClassLoader();
                    try {
                        String serverBuilt;
                        String serverInfo;
                        Properties tomcatServerInfo = IO.readProperties((InputStream)classLoader.getResourceAsStream("org/apache/catalina/util/ServerInfo.properties"), (Properties)new Properties());
                        String serverNumber = tomcatServerInfo.getProperty("server.number");
                        if (serverNumber == null && (serverInfo = tomcatServerInfo.getProperty("server.info")) != null) {
                            int slash = serverInfo.indexOf(47);
                            serverNumber = serverInfo.substring(slash + 1);
                        }
                        if (serverNumber != null) {
                            System.setProperty("tomcat.version", serverNumber);
                        }
                        if ((serverBuilt = tomcatServerInfo.getProperty("server.built")) != null) {
                            System.setProperty("tomcat.built", serverBuilt);
                        }
                    }
                    catch (Throwable tomcatServerInfo) {
                        // empty catch block
                    }
                    loader = new TomcatLoader();
                    loader.initSystemInstance(properties);
                    try {
                        ArrayList<URL> files = new ArrayList<URL>();
                        for (File f : ProvisioningUtil.addAdditionalLibraries()) {
                            files.add(f.toURI().toURL());
                        }
                        ClassLoaderConfigurer configurer = QuickJarsTxtParser.parse((File)SystemInstance.get().getConf("jars.txt"));
                        if (configurer != null) {
                            files.addAll(Arrays.asList(configurer.additionalURLs()));
                        }
                        if (files.isEmpty() || !URLClassLoader.class.isInstance(classLoader)) break block24;
                        URLClassLoader ucl = (URLClassLoader)URLClassLoader.class.cast(classLoader);
                        try {
                            Method addUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                            boolean acc = addUrl.isAccessible();
                            try {
                                for (URL url : files) {
                                    ServerListener.addUrl(ucl, addUrl, url);
                                }
                            }
                            finally {
                                addUrl.setAccessible(acc);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
                loader.initialize(properties);
                listenerInstalled.set(true);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "TomEE Listener can't start OpenEJB", e);
            }
        }
    }

    private static void addUrl(URLClassLoader ucl, Method addUrl, URL url) throws IllegalAccessException, InvocationTargetException, MalformedURLException {
        if (!addUrl.isAccessible()) {
            addUrl.setAccessible(true);
        }
        addUrl.invoke((Object)ucl, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void installServerInfo() {
        if (SystemInstance.get().getOptions().get("tomee.keep-server-info", false)) {
            return;
        }
        String value = ServerInfo.getServerInfo();
        Field field = null;
        boolean acc = true;
        try {
            field = ServerInfo.class.getDeclaredField("serverInfo");
            acc = field.isAccessible();
            int slash = value.indexOf(47);
            field.setAccessible(true);
            String tomeeVersion = OpenEjbVersion.get().getVersion();
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
            }
            field.set(null, value.substring(0, slash) + " (TomEE)" + value.substring(slash) + " (" + tomeeVersion + ")");
        }
        catch (Exception exception) {
        }
        finally {
            if (field != null) {
                field.setAccessible(acc);
            }
        }
    }
}

