/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.app.logs;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AppLogFile {
    public static final String PERFORMANCE_STATISTICS_PREFIX = "perf_measurements_";
    public static final String PERFORMANCE_STATISTICS_DESCRIPTION = "Performance Statistics";
    public static final String ONDEMAND_HEAP_DUMP_ANALYSIS_PREFIX = "ondemand_heap_dump_analysis";
    public static final String HEAP_DUMP_ANALYSIS_DESCRIPTION = "Heap Dump analysis";
    public static final String LAST_ONDEMAND_HEAP_DUMP_RAW_PREFIX = "last_ondemand_heap_dump";
    public static final String LAST_HEAP_DUMP_RAW_DESCRIPTION = "Last heap dump raw file";
    public static final String OOM_HEAP_DUMP_ANALYSIS_PREFIX = "oom_heap_dump_analysis";
    public static final String LAST_OOM_HEAP_DUMP_RAW_PREFIX = "last_oom_heap_dump";
    static final String LJS_TRACE_LOG_PREFIX = "ljs_trace";
    static final String LJS_TRACE_LOG_DESCRIPTION = "Default Trace";
    static final String HTTP_ACCESS_LOG_PREFIX = "http_access";
    static final String HTTP_ACCESS_LOG_DESCRIPTION = "HTTP Access Log";
    static final String GARBAGE_COLLECTION_FILE_PREFIX = "gc";
    static final String GARBAGE_COLLECTION_FILE_DESCRIPTION = "GC file";
    static final String THREAD_DUMP_FILE_PREFIX = "thread_dump";
    static final String THREAD_DUMP_FILE_DESCRIPTION = "Thread dump file";
    static final String CDN_HTTP_ACCESS_LOG_PREFIX = "cdn_http_access";
    static final String CDN_HTTP_ACCESS_LOG_DESCRIPTION = "CDN HTTP Access Log";
    static final String JCO_DEV_RFC_LOG_PREFIX = "dev_jco_rfc";
    static final String JCO_RFC_LOG_PREFIX = "jco_rfc";
    static final String JCO_LOG_DESCRIPTION = "JCo log file";
    static final String DEFAULT_DESCRIPTION = "Log file";
    private static final Map<String, String> DESCRIPTIONS = new HashMap<String, String>();
    private String processId;
    private String name;
    private long size;
    private long lastModified;
    private String description;
    private String component;
    private transient File originalFile;

    static {
        DESCRIPTIONS.put(LJS_TRACE_LOG_PREFIX, LJS_TRACE_LOG_DESCRIPTION);
        DESCRIPTIONS.put(HTTP_ACCESS_LOG_PREFIX, HTTP_ACCESS_LOG_DESCRIPTION);
        DESCRIPTIONS.put(GARBAGE_COLLECTION_FILE_PREFIX, GARBAGE_COLLECTION_FILE_DESCRIPTION);
        DESCRIPTIONS.put(THREAD_DUMP_FILE_PREFIX, THREAD_DUMP_FILE_DESCRIPTION);
        DESCRIPTIONS.put(PERFORMANCE_STATISTICS_PREFIX, PERFORMANCE_STATISTICS_DESCRIPTION);
        DESCRIPTIONS.put(CDN_HTTP_ACCESS_LOG_PREFIX, CDN_HTTP_ACCESS_LOG_DESCRIPTION);
        DESCRIPTIONS.put(ONDEMAND_HEAP_DUMP_ANALYSIS_PREFIX, HEAP_DUMP_ANALYSIS_DESCRIPTION);
        DESCRIPTIONS.put(LAST_ONDEMAND_HEAP_DUMP_RAW_PREFIX, LAST_HEAP_DUMP_RAW_DESCRIPTION);
        DESCRIPTIONS.put(OOM_HEAP_DUMP_ANALYSIS_PREFIX, HEAP_DUMP_ANALYSIS_DESCRIPTION);
        DESCRIPTIONS.put(LAST_OOM_HEAP_DUMP_RAW_PREFIX, LAST_HEAP_DUMP_RAW_DESCRIPTION);
        DESCRIPTIONS.put(JCO_DEV_RFC_LOG_PREFIX, JCO_LOG_DESCRIPTION);
        DESCRIPTIONS.put(JCO_RFC_LOG_PREFIX, JCO_LOG_DESCRIPTION);
    }

    protected AppLogFile() {
    }

    public AppLogFile(File file, String component) {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + file.getAbsolutePath());
        }
        this.name = this.getShortPidName(this.trimGzExtension(file.getName()));
        this.size = file.length();
        this.lastModified = file.lastModified();
        this.description = this.determineDescription();
        this.component = component;
        this.processId = this.getProcessId(file.getName());
        this.originalFile = file;
    }

    protected AppLogFile(AppLogFile appLogFile) {
        this.processId = appLogFile.getProcessId();
        this.name = appLogFile.getName();
        this.size = appLogFile.getSize();
        this.lastModified = appLogFile.getLastModified();
        this.description = appLogFile.getDescription();
        this.component = appLogFile.getComponent();
        this.originalFile = appLogFile.getOriginalFile();
    }

    private String trimGzExtension(String fileName) {
        if (fileName != null && fileName.endsWith(".gz")) {
            return fileName.substring(0, fileName.length() - 3);
        }
        return fileName;
    }

    private String getShortPidName(String fileName) {
        String pid = this.getProcessId(fileName);
        if (pid == null) {
            return fileName;
        }
        String shortPid = this.getShortPid(pid);
        String vsa = this.getVsa(fileName);
        fileName = fileName.replaceAll(pid, shortPid);
        fileName = fileName.replaceAll(String.valueOf(vsa) + "_", "");
        return fileName;
    }

    private String getVsa(String fileName) {
        return this.getRegexMatch(".*_(vsa[0-9]{5,12})_.*", fileName);
    }

    private String getShortPid(String pid) {
        return pid.substring(0, 7);
    }

    private String getProcessId(String fileName) {
        return this.getRegexMatch(".*_([abcdef0-9]{40,40})_.*", fileName);
    }

    private String getRegexMatch(String regex, String name) {
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getComponent() {
        return this.component;
    }

    public String getProcessId() {
        return this.processId;
    }

    File getOriginalFile() {
        return this.originalFile;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppLogFile other = (AppLogFile)obj;
        if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
            return false;
        }
        if (this.lastModified != other.lastModified) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.size == other.size;
    }

    public String toString() {
        return String.format("%s/%s %d bytes %s", this.component, this.name, this.size, new Date(this.lastModified).toString());
    }

    private String determineDescription() {
        String lowercaseName = this.name.toLowerCase(Locale.ENGLISH);
        for (Map.Entry<String, String> entry : DESCRIPTIONS.entrySet()) {
            if (!lowercaseName.startsWith(entry.getKey().toLowerCase(Locale.ENGLISH))) continue;
            return entry.getValue();
        }
        return DEFAULT_DESCRIPTION;
    }
}

