/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.app.logs;

import com.google.gson.Gson;
import com.sap.core.log.dev.app.logs.AppLogFile;
import java.io.File;
import org.apache.log4j.Logger;

public class AppLogFileFactory {
    private static final String ENCODING_UTF_8 = "UTF-8";
    private static final Logger LOGGER = Logger.getLogger(AppLogFileFactory.class);
    private static final Gson GSON = new Gson();

    public static AppLogFile create(File componentFile, String componentName) {
        AppLogFile appLogFile = null;
        try {
            appLogFile = new AppLogFile(componentFile, componentName);
            if ("Performance Statistics".equals(appLogFile.getDescription())) {
                AppLogFile jdsrAppLogFile = AppLogFileFactory.createJdsrAppLogFile(componentFile.getParentFile(), componentName, appLogFile);
                if (jdsrAppLogFile != null) {
                    return jdsrAppLogFile;
                }
                LOGGER.error((Object)"jDSR log file entry was not created successfully, jdsr related fields will be missing");
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)e);
        }
        return appLogFile;
    }

    /*
     * Exception decompiling
     */
    private static AppLogFile createJdsrAppLogFile(File componentDir, String componentName, AppLogFile appLogFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

