/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.app.logs;

import com.sap.core.log.dev.app.logs.AppLogFile;
import com.sap.core.log.dev.app.logs.AppLogFileFactory;
import com.sap.core.log.dev.app.logs.AppLogsFilter;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class AppLogs {
    private static final AppLogsFilter DEFAULT_APP_LOGS_FILTER = new AppLogsFilter();
    private String account;
    private String application;
    private String component;
    private List<AppLogFile> logFiles;

    private AppLogs() {
    }

    @Deprecated
    public AppLogs(File logDir, String requestPath) {
        String[] appAttributes = requestPath.split("/");
        this.account = appAttributes[1];
        this.application = appAttributes[2];
        this.component = appAttributes.length < 4 ? null : appAttributes[3];
        this.readFiles(logDir, null);
    }

    public AppLogs(File logDir, String account, String application) {
        this(logDir, account, application, null, null);
    }

    public AppLogs(File logDir, String account, String application, AppLogsFilter filter) {
        this(logDir, account, application, null, filter);
    }

    public AppLogs(File logDir, String account, String application, String component) {
        this(logDir, account, application, component, null);
    }

    public AppLogs(File logDir, String account, String application, String component, AppLogsFilter filter) {
        this.account = account;
        this.application = application;
        this.component = component;
        this.readFiles(logDir, filter);
    }

    public String getAccount() {
        return this.account;
    }

    public String getApplication() {
        return this.application;
    }

    public List<AppLogFile> getLogFiles() {
        return this.logFiles;
    }

    private void readFiles(File logDir, AppLogsFilter filter) {
        File[] dirList;
        this.logFiles = new LinkedList<AppLogFile>();
        if (logDir == null || !logDir.exists()) {
            return;
        }
        if (this.component != null) {
            this.readComponentFiles(logDir, this.component, filter);
            return;
        }
        File[] fileArray = dirList = logDir.listFiles();
        int n = dirList.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (dir.isDirectory()) {
                this.readComponentFiles(dir, dir.getName(), filter);
            }
            ++n2;
        }
    }

    private void readComponentFiles(File componentDir, String componentName, AppLogsFilter filter) {
        File[] componentFiles;
        File[] fileArray = componentFiles = componentDir.listFiles(filter == null ? DEFAULT_APP_LOGS_FILTER : filter);
        int n = componentFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File componentFile = fileArray[n2];
            AppLogFile f = AppLogFileFactory.create(componentFile, componentName);
            if (f != null) {
                this.logFiles.add(f);
            }
            ++n2;
        }
    }
}

