/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.dev.app.logs;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class AppLogsFilter
implements FilenameFilter {
    private static final List<String> BLACKLIST_PREFIXES = Arrays.asList("jpaas_audit_log", "agent_trace", "agent_daemon", "apparmor", "ngplog", "connectivity_agent", "p2_install", "ngjprovisioning");
    private static final List<String> BLACKLIST_SUFFIXES = Arrays.asList(".part", ".zip.sent");

    @Override
    public boolean accept(File dir, String name) {
        if (name == null) {
            return false;
        }
        return !AppLogsFilter.isBlacklistedPrefix(name, BLACKLIST_PREFIXES) && !AppLogsFilter.isBlacklistedSuffix(name, BLACKLIST_SUFFIXES);
    }

    protected static final boolean isBlacklistedPrefix(String name, List<String> prefixes) {
        String lowercaseName = name.toLowerCase(Locale.ENGLISH);
        for (String prefix : prefixes) {
            if (!lowercaseName.startsWith(prefix.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    protected static final boolean isBlacklistedSuffix(String name, List<String> suffixes) {
        String lowercaseName = name.toLowerCase(Locale.ENGLISH);
        for (String suffix : suffixes) {
            if (!lowercaseName.endsWith(suffix.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }
}

